package co.abit.ares.aws.dynamodb.config;

import co.abit.ares.aws.core.config.AWSProperties;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsyncClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AWSDynamoDbBeanConfig {
    private AWSProperties properties;
    private AWSCredentialsProvider awsCredentialsProvider;

    @Autowired
    public AWSDynamoDbBeanConfig(AWSProperties properties, AWSCredentialsProvider awsCredentialsProvider) {
        this.properties = properties;
        this.awsCredentialsProvider = awsCredentialsProvider;
    }

    @Bean
    @ConditionalOnMissingBean
    public AmazonDynamoDB amazonDynamoDB() {
        return AmazonDynamoDBClientBuilder.standard()
                .withCredentials(awsCredentialsProvider)
                .withEndpointConfiguration(getDynamoDBEndpointConfiguration())
                .build();
    }

    @Bean
    @ConditionalOnMissingBean
    public AmazonDynamoDBAsync amazonDynamoDBAsync() {
        return AmazonDynamoDBAsyncClientBuilder.standard()
                .withCredentials(awsCredentialsProvider)
                .withEndpointConfiguration(getDynamoDBEndpointConfiguration())
                .build();
    }

    private AwsClientBuilder.EndpointConfiguration getDynamoDBEndpointConfiguration() {
        String dynamoDBEndpoint = properties.getDynamodbEndpoint();
        if (dynamoDBEndpoint.isEmpty()) {
            return new AwsClientBuilder.EndpointConfiguration(null, properties.getRegion());
        }

        return new AwsClientBuilder.EndpointConfiguration(dynamoDBEndpoint, properties.getRegion());
    }
}
