/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.spring.common;

import cn.wanghaomiao.seimi.config.SeimiConfig;
import cn.wanghaomiao.seimi.core.SeimiProcessor;
import cn.wanghaomiao.seimi.exception.SeimiInitExcepiton;
import cn.wanghaomiao.seimi.spring.boot.CrawlerProperties;
import cn.wanghaomiao.seimi.spring.common.CrawlerCache;
import cn.wanghaomiao.seimi.struct.CrawlerModel;
import cn.wanghaomiao.seimi.utils.StrFormatUtil;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.util.CollectionUtils;

public class SeimiCrawlerBootstrapListener
implements ApplicationListener<ContextRefreshedEvent> {
    private ExecutorService workersPool;
    private boolean isSpringBoot = false;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public SeimiCrawlerBootstrapListener() {
    }

    public SeimiCrawlerBootstrapListener(boolean isSpringBoot) {
        this.isSpringBoot = isSpringBoot;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        Object crawlerProperties;
        ApplicationContext context = event.getApplicationContext();
        if (this.isSpringBoot && !((CrawlerProperties)(crawlerProperties = (CrawlerProperties)context.getBean(CrawlerProperties.class))).isEnabled()) {
            this.logger.warn("{} is not enabled", (Object)"seimi.crawler.enabled");
            return;
        }
        if (context != null) {
            if (CollectionUtils.isEmpty(CrawlerCache.getCrawlers())) {
                this.logger.info("Not find any crawler,may be you need to check.");
                return;
            }
            this.workersPool = Executors.newFixedThreadPool(4 * Runtime.getRuntime().availableProcessors() * CrawlerCache.getCrawlers().size());
            for (Class clazz : CrawlerCache.getCrawlers()) {
                CrawlerModel crawlerModel = new CrawlerModel(clazz, context);
                if (CrawlerCache.isExist(crawlerModel.getCrawlerName())) {
                    this.logger.error("Crawler:{} is repeated,please check", (Object)crawlerModel.getCrawlerName());
                    throw new SeimiInitExcepiton(StrFormatUtil.info("Crawler:{} is repeated,please check", crawlerModel.getCrawlerName()));
                }
                CrawlerCache.putCrawlerModel(crawlerModel.getCrawlerName(), crawlerModel);
            }
            for (Map.Entry<String, CrawlerModel> entry : CrawlerCache.getCrawlerModelContext().entrySet()) {
                for (int i = 0; i < 4 * Runtime.getRuntime().availableProcessors(); ++i) {
                    this.workersPool.execute(new SeimiProcessor(CrawlerCache.getInterceptors(), entry.getValue()));
                }
            }
            if (this.isSpringBoot) {
                crawlerProperties = (CrawlerProperties)context.getBean(CrawlerProperties.class);
                String string = ((CrawlerProperties)crawlerProperties).getNames();
                if (StringUtils.isBlank((CharSequence)string)) {
                    this.logger.info("Spring boot start [{}] as worker.", (Object)StringUtils.join(CrawlerCache.getCrawlerModelContext().keySet(), (String)","));
                } else {
                    String[] crawlers;
                    for (String cn : crawlers = string.split(",")) {
                        CrawlerModel crawlerModel = CrawlerCache.getCrawlerModel(cn);
                        if (crawlerModel == null) {
                            this.logger.warn("Crawler name = {} is not existent.", (Object)cn);
                            continue;
                        }
                        crawlerModel.startRequest();
                    }
                }
                SeimiConfig config = new SeimiConfig();
                config.setBloomFilterExpectedInsertions(((CrawlerProperties)crawlerProperties).getBloomFilterExpectedInsertions());
                config.setBloomFilterFalseProbability(((CrawlerProperties)crawlerProperties).getBloomFilterFalseProbability());
                config.setSeimiAgentHost(((CrawlerProperties)crawlerProperties).getSeimiAgentHost());
                config.setSeimiAgentPort(((CrawlerProperties)crawlerProperties).getSeimiAgentPort());
                CrawlerCache.setConfig(config);
            }
        }
    }
}

