/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.core;

import cn.wanghaomiao.seimi.config.SeimiConfig;
import cn.wanghaomiao.seimi.core.SeimiContext;
import cn.wanghaomiao.seimi.httpd.CrawlerStatusHttpProcessor;
import cn.wanghaomiao.seimi.httpd.PushRequestHttpProcessor;
import cn.wanghaomiao.seimi.httpd.SeimiHttpHandler;
import cn.wanghaomiao.seimi.spring.common.CrawlerCache;
import cn.wanghaomiao.seimi.struct.CrawlerModel;
import java.util.Map;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Seimi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SeimiConfig config;

    public Seimi(SeimiConfig config) {
        this.config = config;
    }

    public Seimi() {
        this.config = null;
    }

    public void goRun(boolean ifBlock, String ... crawlerNames) {
        if (crawlerNames == null || crawlerNames.length == 0) {
            this.logger.info("start all crawler as workers.");
        } else {
            SeimiContext.init(this.config);
            for (String name : crawlerNames) {
                CrawlerModel crawlerModel = CrawlerCache.getCrawlerModel(name);
                if (crawlerModel != null) {
                    crawlerModel.startRequest();
                    continue;
                }
                this.logger.error("error crawler name '{}',can not find it!", (Object)name);
            }
        }
    }

    public void goRun(String ... crawlerNames) {
        this.goRun(true, crawlerNames);
    }

    @Deprecated
    public void start(String ... crawlerNames) {
        this.goRun(true, crawlerNames);
    }

    public void goRunWithHttpd(int port, String ... crawlerNames) {
        this.goRun(false, crawlerNames);
        Map<String, CrawlerModel> crawlerModelContext = CrawlerCache.getCrawlerModelContext();
        SeimiHttpHandler seimiHttpHandler = new SeimiHttpHandler(crawlerModelContext);
        if (crawlerNames == null || crawlerNames.length == 0) {
            for (Map.Entry<String, CrawlerModel> entry : crawlerModelContext.entrySet()) {
                seimiHttpHandler.add("/push/" + entry.getKey(), new PushRequestHttpProcessor(entry.getValue().getQueueInstance(), entry.getKey())).add("/status/" + entry.getKey(), new CrawlerStatusHttpProcessor(entry.getValue().getQueueInstance(), entry.getKey()));
            }
        } else {
            for (String name : crawlerNames) {
                CrawlerModel crawlerModel = crawlerModelContext.get(name);
                if (crawlerModel == null) continue;
                seimiHttpHandler.add("/push/" + name, new PushRequestHttpProcessor(crawlerModel.getQueueInstance(), name)).add("/status/" + name, new CrawlerStatusHttpProcessor(crawlerModel.getQueueInstance(), name));
            }
        }
        this.logger.info("Http request push service also started on port:{}", (Object)port);
        this.startJetty(port, seimiHttpHandler);
    }

    public void startAll() {
        SeimiContext.init(this.config);
        for (Map.Entry<String, CrawlerModel> entry : CrawlerCache.getCrawlerModelContext().entrySet()) {
            entry.getValue().startRequest();
        }
    }

    private void startJetty(int port, SeimiHttpHandler seimiHttpHandler) {
        Server server = new Server(port);
        server.setHandler((Handler)seimiHttpHandler);
        try {
            server.start();
            server.join();
        }
        catch (Exception e) {
            this.logger.error("http service start error,{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

