/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.http.okhttp;

import cn.wanghaomiao.seimi.def.BaseSeimiCrawler;
import cn.wanghaomiao.seimi.exception.SeimiProcessExcepiton;
import cn.wanghaomiao.seimi.http.HttpMethod;
import cn.wanghaomiao.seimi.http.SeimiAgentContentType;
import cn.wanghaomiao.seimi.struct.CrawlerModel;
import cn.wanghaomiao.seimi.struct.Request;
import com.alibaba.fastjson.JSON;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class OkHttpRequestGenerator {
    public static Request.Builder getOkHttpRequesBuilder(Request seimiReq, CrawlerModel crawlerModel) {
        BaseSeimiCrawler crawler = crawlerModel.getInstance();
        Request.Builder requestBuilder = new Request.Builder();
        if (seimiReq.isUseSeimiAgent()) {
            if (StringUtils.isBlank((CharSequence)crawler.seimiAgentHost())) {
                throw new SeimiProcessExcepiton("SeimiAgentHost is blank.");
            }
            String seimiAgentUrl = "http://" + crawler.seimiAgentHost() + (crawler.seimiAgentPort() != 80 ? ":" + crawler.seimiAgentPort() : "") + "/doload";
            FormBody.Builder formBodyBuilder = new FormBody.Builder().add("url", seimiReq.getUrl());
            if (StringUtils.isNotBlank((CharSequence)crawler.proxy())) {
                formBodyBuilder.add("proxy", crawler.proxy());
            }
            if (seimiReq.getSeimiAgentRenderTime() > 0L) {
                formBodyBuilder.add("renderTime", String.valueOf(seimiReq.getSeimiAgentRenderTime()));
            }
            if (StringUtils.isNotBlank((CharSequence)seimiReq.getSeimiAgentScript())) {
                formBodyBuilder.add("script", seimiReq.getSeimiAgentScript());
            }
            if (seimiReq.isSeimiAgentUseCookie() == null && crawlerModel.isUseCookie() || seimiReq.isSeimiAgentUseCookie() != null && seimiReq.isSeimiAgentUseCookie().booleanValue()) {
                formBodyBuilder.add("useCookie", "1");
            }
            if (seimiReq.getParams() != null && seimiReq.getParams().size() > 0) {
                formBodyBuilder.add("postParam", JSON.toJSONString(seimiReq.getParams()));
            }
            if (seimiReq.getSeimiAgentContentType().val() > SeimiAgentContentType.HTML.val()) {
                formBodyBuilder.add("contentType", seimiReq.getSeimiAgentContentType().typeVal());
            }
            requestBuilder.url(seimiAgentUrl).post((RequestBody)formBodyBuilder.build()).build();
        } else {
            requestBuilder.url(seimiReq.getUrl());
            requestBuilder.header("User-Agent", crawlerModel.isUseCookie() ? crawlerModel.getCurrentUA() : crawler.getUserAgent()).header("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8").header("Accept-Language", "zh-CN,zh;q=0.8,en;q=0.6");
            if (!CollectionUtils.isEmpty(seimiReq.getHeader())) {
                for (Map.Entry<String, String> entry : seimiReq.getHeader().entrySet()) {
                    requestBuilder.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if (HttpMethod.POST.equals((Object)seimiReq.getHttpMethod())) {
                FormBody.Builder formBodyBuilder = new FormBody.Builder();
                if (seimiReq.getParams() != null) {
                    for (Map.Entry<String, String> entry : seimiReq.getParams().entrySet()) {
                        formBodyBuilder.add(entry.getKey(), entry.getValue());
                    }
                }
                requestBuilder.post((RequestBody)formBodyBuilder.build());
            } else {
                String queryStr = "";
                if (seimiReq.getParams() != null && !seimiReq.getParams().isEmpty()) {
                    queryStr = queryStr + "?";
                    for (Map.Entry<String, String> entry : seimiReq.getParams().entrySet()) {
                        queryStr = queryStr + entry.getKey() + "=" + entry.getValue() + "&";
                    }
                    requestBuilder.url(seimiReq.getUrl() + queryStr);
                }
                requestBuilder.get();
            }
        }
        return requestBuilder;
    }
}

