/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.http.hc;

import cn.wanghaomiao.seimi.def.BaseSeimiCrawler;
import cn.wanghaomiao.seimi.exception.SeimiProcessExcepiton;
import cn.wanghaomiao.seimi.http.HttpMethod;
import cn.wanghaomiao.seimi.http.SeimiAgentContentType;
import cn.wanghaomiao.seimi.struct.CrawlerModel;
import cn.wanghaomiao.seimi.struct.Request;
import com.alibaba.fastjson.JSON;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.util.CollectionUtils;

public class HcRequestGenerator {
    public static RequestBuilder getHttpRequestBuilder(Request request, CrawlerModel crawlerModel) {
        RequestBuilder requestBuilder;
        BaseSeimiCrawler crawler = crawlerModel.getInstance();
        if (request.isUseSeimiAgent()) {
            if (StringUtils.isBlank((CharSequence)crawler.seimiAgentHost())) {
                throw new SeimiProcessExcepiton("SeimiAgentHost is blank.");
            }
            String seimiAgentUrl = "http://" + crawler.seimiAgentHost() + (crawler.seimiAgentPort() != 80 ? ":" + crawler.seimiAgentPort() : "") + "/doload";
            requestBuilder = RequestBuilder.post().setUri(seimiAgentUrl);
            LinkedList<BasicNameValuePair> nameValuePairList = new LinkedList<BasicNameValuePair>();
            nameValuePairList.add(new BasicNameValuePair("url", request.getUrl()));
            if (StringUtils.isNotBlank((CharSequence)crawler.proxy())) {
                nameValuePairList.add(new BasicNameValuePair("proxy", crawler.proxy()));
            }
            if (request.getSeimiAgentRenderTime() > 0L) {
                nameValuePairList.add(new BasicNameValuePair("renderTime", String.valueOf(request.getSeimiAgentRenderTime())));
            }
            if (StringUtils.isNotBlank((CharSequence)request.getSeimiAgentScript())) {
                nameValuePairList.add(new BasicNameValuePair("script", request.getSeimiAgentScript()));
            }
            if (request.isSeimiAgentUseCookie() == null && crawlerModel.isUseCookie() || request.isSeimiAgentUseCookie() != null && request.isSeimiAgentUseCookie().booleanValue()) {
                nameValuePairList.add(new BasicNameValuePair("useCookie", "1"));
            }
            if (request.getParams() != null && request.getParams().size() > 0) {
                nameValuePairList.add(new BasicNameValuePair("postParam", JSON.toJSONString(request.getParams())));
            }
            if (request.getSeimiAgentContentType().val() > SeimiAgentContentType.HTML.val()) {
                nameValuePairList.add(new BasicNameValuePair("contentType", request.getSeimiAgentContentType().typeVal()));
            }
            requestBuilder.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairList, Charset.forName("utf8")));
        } else {
            if (HttpMethod.POST.equals((Object)request.getHttpMethod())) {
                requestBuilder = RequestBuilder.post().setUri(request.getUrl());
                if (request.getParams() != null) {
                    LinkedList<BasicNameValuePair> nameValuePairList = new LinkedList<BasicNameValuePair>();
                    for (Map.Entry<String, String> entry : request.getParams().entrySet()) {
                        nameValuePairList.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                    }
                    requestBuilder.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairList, Charset.forName("utf8")));
                }
            } else {
                requestBuilder = RequestBuilder.get().setUri(request.getUrl());
                if (request.getParams() != null) {
                    for (Map.Entry<String, String> entry : request.getParams().entrySet()) {
                        requestBuilder.addParameter(entry.getKey(), entry.getValue());
                    }
                }
            }
            RequestConfig config = RequestConfig.custom().setProxy(crawlerModel.getProxy()).setCircularRedirectsAllowed(true).build();
            requestBuilder.setConfig(config).setHeader("User-Agent", crawlerModel.isUseCookie() ? crawlerModel.getCurrentUA() : crawler.getUserAgent());
            requestBuilder.setHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
            requestBuilder.setHeader("Accept-Language", "zh-CN,zh;q=0.8,en;q=0.6");
        }
        if (!CollectionUtils.isEmpty(request.getHeader())) {
            for (Map.Entry<String, String> entry : request.getHeader().entrySet()) {
                requestBuilder.setHeader(entry.getKey(), entry.getValue());
            }
        }
        return requestBuilder;
    }
}

