/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.def;

import cn.wanghaomiao.seimi.annotation.Queue;
import cn.wanghaomiao.seimi.core.SeimiQueue;
import cn.wanghaomiao.seimi.struct.Request;
import cn.wanghaomiao.seimi.utils.GenericUtils;
import com.alibaba.fastjson.JSON;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Queue
public class DefaultRedisQueue
implements SeimiQueue {
    @Value(value="${redis.host:127.0.0.1}")
    private String host;
    @Value(value="${redis.port:6379}")
    private int port;
    @Value(value="${redis.password:}")
    private String password;
    private String quueNamePrefix = "SEIMI_CRAWLER_QUEUE_";
    private String setNamePrefix = "SEIMI_CRAWLER_SET_";
    private JedisPool wpool = null;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @PostConstruct
    public void init() {
        this.getWritePool();
    }

    public void refresh() {
        if (this.wpool != null) {
            this.wpool.destroy();
            this.wpool = null;
        }
    }

    public synchronized JedisPool getWritePool() {
        if (this.wpool == null) {
            JedisPoolConfig config = new JedisPoolConfig();
            config.setMaxTotal(50);
            config.setMaxIdle(20);
            config.setMinIdle(10);
            config.setMaxWaitMillis(20000L);
            this.logger.info("create redisPool host={},port={}", (Object)this.host, (Object)this.port);
            this.wpool = StringUtils.isNotBlank((CharSequence)this.password) ? new JedisPool((GenericObjectPoolConfig)config, this.host, this.port, 0, this.password) : new JedisPool((GenericObjectPoolConfig)config, this.host, this.port, 0);
        }
        return this.wpool;
    }

    public Jedis getWClient() {
        return this.getWritePool().getResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Request bPop(String crawlerName) {
        Request request = null;
        try (Jedis jedis = null;){
            jedis = this.getWClient();
            List res = jedis.brpop(0, this.quueNamePrefix + crawlerName);
            request = (Request)JSON.parseObject((String)((String)res.get(1)), Request.class);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean push(Request req) {
        boolean res = false;
        try (Jedis jedis = null;){
            jedis = this.getWClient();
            res = jedis.lpush(this.quueNamePrefix + req.getCrawlerName(), new String[]{JSON.toJSONString((Object)req)}) > 0L;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long len(String crawlerName) {
        long len = 0L;
        try (Jedis jedis = null;){
            jedis = this.getWClient();
            len = jedis.llen(this.quueNamePrefix + crawlerName);
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProcessed(Request req) {
        boolean res = false;
        try (Jedis jedis = null;){
            jedis = this.getWClient();
            String sign = GenericUtils.signRequest(req);
            res = jedis.sismember(this.setNamePrefix + req.getCrawlerName(), sign);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProcessed(Request req) {
        try (Jedis jedis = null;){
            jedis = this.getWClient();
            String sign = DigestUtils.md5Hex((String)req.getUrl());
            jedis.sadd(this.setNamePrefix + req.getCrawlerName(), new String[]{sign});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long totalCrawled(String crawlerName) {
        long count = 0L;
        try (Jedis jedis = null;){
            jedis = this.getWClient();
            count = jedis.scard(this.setNamePrefix + crawlerName);
        }
        return count;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getQuueNamePrefix() {
        return this.quueNamePrefix;
    }

    public void setQuueNamePrefix(String quueNamePrefix) {
        this.quueNamePrefix = quueNamePrefix;
    }
}

