/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.utils;

import cn.wanghaomiao.seimi.annotation.validate.NotNull;
import java.lang.reflect.Field;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class StructValidator {
    private static final Logger logger = LoggerFactory.getLogger(StructValidator.class);

    public static boolean validateAnno(Object object) {
        for (Field field : object.getClass().getDeclaredFields()) {
            NotNull notNullCheck = field.getAnnotation(NotNull.class);
            if (notNullCheck == null) continue;
            try {
                Object val = FieldUtils.readField((Field)field, (Object)object, (boolean)true);
                if (!StringUtils.isBlank((CharSequence)String.valueOf(val))) continue;
                logger.error("Field={}.{} can not be null!", (Object)object.getClass().getSimpleName(), (Object)field.getName());
                return false;
            }
            catch (IllegalAccessException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    public static boolean validateAllowRules(String[] rules, String target) {
        if (ArrayUtils.isEmpty((Object[])rules)) {
            return true;
        }
        Assert.notNull((Object)target, (String)"rule target can not be null");
        for (String rule : rules) {
            if (!target.matches(rule)) continue;
            return true;
        }
        return false;
    }

    public static boolean validateDenyRules(String[] rules, String target) {
        if (ArrayUtils.isEmpty((Object[])rules)) {
            return false;
        }
        Assert.notNull((Object)target, (String)"rule target can not be null");
        for (String rule : rules) {
            if (!target.matches(rule)) continue;
            return true;
        }
        return false;
    }
}

