/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.http.okhttp;

import cn.wanghaomiao.seimi.core.SeimiDownloader;
import cn.wanghaomiao.seimi.http.SeimiHttpType;
import cn.wanghaomiao.seimi.http.okhttp.CookiesMgrProvider;
import cn.wanghaomiao.seimi.http.okhttp.OkHttpClientBuilderProvider;
import cn.wanghaomiao.seimi.http.okhttp.OkHttpRequestGenerator;
import cn.wanghaomiao.seimi.struct.BodyType;
import cn.wanghaomiao.seimi.struct.CrawlerModel;
import cn.wanghaomiao.seimi.struct.Request;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpDownloader
implements SeimiDownloader {
    private CrawlerModel crawlerModel;
    private Request currentRequest;
    private Request.Builder currentRequestBuilder;
    private OkHttpClient okHttpClient;
    private Response lastResponse;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public OkHttpDownloader(CrawlerModel crawlerModel) {
        this.crawlerModel = crawlerModel;
    }

    @Override
    public cn.wanghaomiao.seimi.struct.Response process(Request request) throws Exception {
        this.currentRequest = request;
        OkHttpClient.Builder hcBuilder = OkHttpClientBuilderProvider.getInstance();
        if (this.crawlerModel.isUseCookie()) {
            hcBuilder.cookieJar((CookieJar)CookiesMgrProvider.getInstance());
        }
        if (this.crawlerModel.getStdProxy() != null) {
            hcBuilder.proxy(this.crawlerModel.getStdProxy());
        }
        this.okHttpClient = hcBuilder.build();
        this.currentRequestBuilder = OkHttpRequestGenerator.getOkHttpRequesBuilder(request, this.crawlerModel);
        this.lastResponse = this.okHttpClient.newCall(this.currentRequestBuilder.build()).execute();
        return this.renderResponse(this.lastResponse, request);
    }

    @Override
    public cn.wanghaomiao.seimi.struct.Response metaRefresh(String nextUrl) throws Exception {
        HttpUrl lastUrl = this.lastResponse.request().url();
        if (!nextUrl.startsWith("http")) {
            String prefix = lastUrl.host() + lastUrl.encodedPath();
            nextUrl = prefix + nextUrl;
        }
        this.logger.info("Seimi refresh url to={} from={}", (Object)nextUrl, (Object)lastUrl.toString());
        this.currentRequestBuilder.url(nextUrl);
        this.lastResponse = this.okHttpClient.newCall(this.currentRequestBuilder.build()).execute();
        return this.renderResponse(this.lastResponse, this.currentRequest);
    }

    @Override
    public int statusCode() {
        return this.lastResponse.code();
    }

    private cn.wanghaomiao.seimi.struct.Response renderResponse(Response hcResponse, Request request) {
        cn.wanghaomiao.seimi.struct.Response seimiResponse = new cn.wanghaomiao.seimi.struct.Response();
        seimiResponse.setSeimiHttpType(SeimiHttpType.OK_HTTP3);
        seimiResponse.setRealUrl(this.lastResponse.request().url().toString());
        seimiResponse.setUrl(request.getUrl());
        seimiResponse.setRequest(request);
        seimiResponse.setMeta(request.getMeta());
        seimiResponse.setReferer(hcResponse.header("Referer"));
        ResponseBody okResponseBody = hcResponse.body();
        if (okResponseBody != null) {
            String type = okResponseBody.contentType().type().toLowerCase();
            String subtype = okResponseBody.contentType().subtype().toLowerCase();
            if (type.contains("text") || type.contains("json") || type.contains("ajax") || subtype.contains("json") || subtype.contains("ajax")) {
                seimiResponse.setBodyType(BodyType.TEXT);
                try {
                    seimiResponse.setContent(okResponseBody.string());
                }
                catch (Exception e) {
                    this.logger.error("no content data");
                }
            } else {
                seimiResponse.setBodyType(BodyType.BINARY);
                try {
                    seimiResponse.setData(okResponseBody.bytes());
                }
                catch (Exception e) {
                    this.logger.error("no content data");
                }
            }
        }
        return seimiResponse;
    }
}

