/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.struct;

import cn.wanghaomiao.seimi.annotation.validate.NotNull;
import cn.wanghaomiao.seimi.http.HttpMethod;
import cn.wanghaomiao.seimi.struct.CommonObject;
import java.util.Map;

public class Request
extends CommonObject {
    @NotNull
    private String crawlerName;
    @NotNull
    private String url;
    private HttpMethod httpMethod;
    private Map<String, String> params;
    private Map<String, String> meta;
    @NotNull
    private String callBack;
    private boolean stop = false;
    private int maxReqCount = 3;
    private int currentReqCount = 0;
    private boolean skipDuplicateFilter = false;

    public Request(String url, String callBack, HttpMethod httpMethod, Map<String, String> params, Map<String, String> meta, int maxReqCount) {
        this.url = url;
        this.httpMethod = httpMethod;
        this.params = params;
        this.meta = meta;
        this.callBack = callBack;
        this.maxReqCount = maxReqCount;
    }

    public Request(String url, String callBack, HttpMethod httpMethod, Map<String, String> params, Map<String, String> meta) {
        this.url = url;
        this.httpMethod = httpMethod;
        this.params = params;
        this.meta = meta;
        this.callBack = callBack;
    }

    public Request(String url, String callBack) {
        this.url = url;
        this.callBack = callBack;
    }

    public Request(String url, String callBack, int maxReqCount) {
        this.url = url;
        this.callBack = callBack;
        this.maxReqCount = this.maxReqCount;
    }

    public static Request build(String url, String callBack, HttpMethod httpMethod, Map<String, String> params, Map<String, String> meta) {
        return new Request(url, callBack, httpMethod, params, meta);
    }

    public static Request build(String url, String callBack, HttpMethod httpMethod, Map<String, String> params, Map<String, String> meta, int maxReqcount) {
        return new Request(url, callBack, httpMethod, params, meta, maxReqcount);
    }

    public static Request build(String url, String callBack) {
        return new Request(url, callBack);
    }

    public static Request build(String url, String callBack, int maxReqCount) {
        return new Request(url, callBack, maxReqCount);
    }

    public Request() {
    }

    public void incrReqCount() {
        ++this.currentReqCount;
    }

    public String getUrl() {
        return this.url;
    }

    public Request setUrl(String url) {
        this.url = url;
        return this;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public Request setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public Request setParams(Map<String, String> params) {
        this.params = params;
        return this;
    }

    public Map<String, String> getMeta() {
        return this.meta;
    }

    public Request setMeta(Map<String, String> meta) {
        this.meta = meta;
        return this;
    }

    public String getCallBack() {
        return this.callBack;
    }

    public Request setCallBack(String callBack) {
        this.callBack = callBack;
        return this;
    }

    public boolean isStop() {
        return this.stop;
    }

    public Request setStop(boolean stop) {
        this.stop = stop;
        return this;
    }

    public int getMaxReqCount() {
        return this.maxReqCount;
    }

    public Request setMaxReqCount(int maxReqCount) {
        this.maxReqCount = maxReqCount;
        return this;
    }

    public int getCurrentReqCount() {
        return this.currentReqCount;
    }

    public Request setCurrentReqCount(int currentReqCount) {
        this.currentReqCount = currentReqCount;
        return this;
    }

    public boolean isSkipDuplicateFilter() {
        return this.skipDuplicateFilter;
    }

    public Request setSkipDuplicateFilter(boolean skipDuplicateFilter) {
        this.skipDuplicateFilter = skipDuplicateFilter;
        return this;
    }

    public String getCrawlerName() {
        return this.crawlerName;
    }

    public Request setCrawlerName(String crawlerName) {
        this.crawlerName = crawlerName;
        return this;
    }
}

