/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.struct;

import cn.wanghaomiao.seimi.core.SeimiBeanResolver;
import cn.wanghaomiao.seimi.struct.BodyType;
import cn.wanghaomiao.seimi.struct.CommonObject;
import cn.wanghaomiao.seimi.struct.Request;
import cn.wanghaomiao.xpath.model.JXDocument;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Response
extends CommonObject {
    private BodyType bodyType;
    private HttpResponse httpResponse;
    private HttpEntity reponseEntity;
    private Request request;
    private String charset;
    private String referer;
    private byte[] data;
    private String content;
    private Map<String, Object> meta;
    private String url;
    private Map<String, String> params;
    private Logger logger = LoggerFactory.getLogger(Response.class);

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public BodyType getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(BodyType bodyType) {
        this.bodyType = bodyType;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Map<String, Object> getMeta() {
        return this.meta;
    }

    public void setMeta(Map<String, Object> meta) {
        this.meta = meta;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public void setHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public HttpEntity getReponseEntity() {
        return this.reponseEntity;
    }

    public void setReponseEntity(HttpEntity reponseEntity) {
        this.reponseEntity = reponseEntity;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public String getReferer() {
        return this.referer;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public <T> T render(Class<T> bean) throws Exception {
        if (this.bodyType.equals((Object)BodyType.TEXT)) {
            return SeimiBeanResolver.parse(bean, this.content);
        }
        throw new RuntimeException("can not parse struct from binary");
    }

    public JXDocument document() {
        return BodyType.TEXT.equals((Object)this.bodyType) && this.content != null ? new JXDocument(this.content) : null;
    }

    public void saveTo(File targetFile) {
        AbstractInterruptibleChannel fo = null;
        try {
            File pf = targetFile.getParentFile();
            if (!pf.exists()) {
                pf.mkdirs();
            }
            fo = new FileOutputStream(targetFile).getChannel();
            if (BodyType.TEXT.equals((Object)this.bodyType)) {
                ((FileChannel)fo).write(ByteBuffer.wrap(this.getContent().getBytes()));
            } else {
                ((FileChannel)fo).write(ByteBuffer.wrap(this.getData()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fo != null) {
                try {
                    fo.close();
                }
                catch (IOException ignore) {
                    this.logger.error(ignore.getMessage(), (Throwable)ignore);
                }
            }
        }
    }
}

