/*
 * Decompiled with CFR 0.152.
 */
package org.seimicrawler.xpath.core.function;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.time.FastDateFormat;
import org.seimicrawler.xpath.core.Function;
import org.seimicrawler.xpath.core.Scope;
import org.seimicrawler.xpath.core.XValue;
import org.seimicrawler.xpath.exception.XpathParserException;

public class FormatDate
implements Function {
    @Override
    public String name() {
        return "format-date";
    }

    @Override
    public XValue call(Scope scope, List<XValue> params) {
        String value = params.get(0).asString();
        String patten = params.get(1).asString();
        try {
            if (params.size() > 2 && null != params.get(2)) {
                Locale locale = Locale.forLanguageTag(params.get(2).asString());
                SimpleDateFormat format = new SimpleDateFormat(patten, locale);
                return XValue.create(format.parse(value));
            }
            return XValue.create(FastDateFormat.getInstance((String)patten).parse(value));
        }
        catch (ParseException e) {
            throw new XpathParserException("date format exception!", e);
        }
    }
}

