/*
 * Decompiled with CFR 0.152.
 */
package org.seimicrawler.xpath.core;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.jsoup.select.Elements;
import org.seimicrawler.xpath.exception.XpathParserException;

public class XValue
implements Comparable<XValue> {
    private Object value;
    private boolean isAttr = false;
    private boolean isExprStr = false;
    private int siblingIndex;
    private List<XValue> xValues;

    public XValue(Object val) {
        this.value = val;
    }

    public static XValue create(Object val) {
        return new XValue(val);
    }

    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    public boolean isNumber() {
        return this.value instanceof Number;
    }

    public boolean isElements() {
        return this.value instanceof Elements;
    }

    public boolean isString() {
        return this.value instanceof String;
    }

    public boolean isList() {
        return this.value instanceof List;
    }

    public boolean isDate() {
        return this.value instanceof Date;
    }

    public Boolean asBoolean() {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        return this.value != null && !StringUtils.isBlank((CharSequence)this.asString());
    }

    public Date asDate() {
        if (this.value instanceof String) {
            try {
                return DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.parse((String)this.value);
            }
            catch (ParseException e) {
                throw new XpathParserException("cast to date fail. vale = " + this.value);
            }
        }
        if (this.value instanceof Date) {
            return (Date)this.value;
        }
        throw new XpathParserException("cast to date fail. vale = " + this.value);
    }

    public Double asDouble() {
        if (this.value instanceof String) {
            return new BigDecimal((String)this.value).doubleValue();
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).doubleValue();
        }
        throw new XpathParserException("cast to number fail. vale = " + this.value);
    }

    public Long asLong() {
        if (this.value instanceof String) {
            return new BigDecimal((String)this.value).setScale(0, 4).longValue();
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).longValue();
        }
        throw new XpathParserException("cast to number fail. vale = " + this.value);
    }

    public Elements asElements() {
        return (Elements)this.value;
    }

    public String asString() {
        if (this.value instanceof List) {
            return StringUtils.join((Iterable)((List)this.value), (String)",");
        }
        return String.valueOf(this.value).trim();
    }

    public List<String> asList() {
        return (List)this.value;
    }

    public XValue attr() {
        this.isAttr = true;
        return this;
    }

    public boolean isAttr() {
        return this.isAttr;
    }

    public XValue exprStr() {
        this.isExprStr = true;
        String str = StringUtils.removeStart((String)String.valueOf(this.value), (String)"'");
        str = StringUtils.removeStart((String)str, (String)"\"");
        str = StringUtils.removeEnd((String)str, (String)"'");
        this.value = StringUtils.removeEnd((String)str, (String)"\"");
        return this;
    }

    public boolean isExprStr() {
        return this.isExprStr;
    }

    public int getSiblingIndex() {
        return this.siblingIndex;
    }

    public void setSiblingIndex(int siblingIndex) {
        this.siblingIndex = siblingIndex;
    }

    public List<XValue> getxValues() {
        return this.xValues;
    }

    public void setxValues(List<XValue> xValues) {
        this.xValues = xValues;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("value", this.value).append("isAttr", this.isAttr).append("isExprStr", this.isExprStr).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XValue value1 = (XValue)o;
        return Objects.equals(this.value, value1.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    @Override
    public int compareTo(XValue o) {
        if (this.equals(o)) {
            return 0;
        }
        if (o == null || o.value == null) {
            return 1;
        }
        if (this.value == null) {
            return -1;
        }
        if (this.isString()) {
            return this.asString().compareTo(o.asString());
        }
        if (this.isNumber()) {
            return this.asDouble().compareTo(o.asDouble());
        }
        throw new XpathParserException("Unsupported comparable XValue = " + this.toString());
    }

    public Class valType() {
        if (this.value == null) {
            return Object.class;
        }
        return this.value.getClass();
    }
}

