/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.xpath.model;

import cn.wanghaomiao.xpath.core.XpathEvaluator;
import cn.wanghaomiao.xpath.exception.NoSuchAxisException;
import cn.wanghaomiao.xpath.exception.NoSuchFunctionException;
import cn.wanghaomiao.xpath.exception.XpathSyntaxErrorException;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

public class JXDocument {
    private Elements elements;
    private XpathEvaluator xpathEva = new XpathEvaluator();

    public JXDocument(Document doc) {
        this.elements = doc.children();
    }

    public JXDocument(String html) {
        this.elements = Jsoup.parse((String)html).children();
    }

    public JXDocument(Elements els) {
        this.elements = els;
    }

    public List<Object> sel(String xpath) throws NoSuchAxisException, NoSuchFunctionException, XpathSyntaxErrorException {
        List<Object> res = null;
        try {
            res = this.xpathEva.xpathParser(xpath, this.elements);
        }
        catch (NoSuchAxisException e) {
            throw e;
        }
        catch (NoSuchFunctionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XpathSyntaxErrorException("please check the xpath syntax");
        }
        return res;
    }
}

