/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.xpath.core;

import cn.wanghaomiao.xpath.core.AxisSelector;
import cn.wanghaomiao.xpath.core.Functions;
import cn.wanghaomiao.xpath.core.NodeTreeBuilderStateMachine;
import cn.wanghaomiao.xpath.core.SingletonProducer;
import cn.wanghaomiao.xpath.exception.NoSuchAxisException;
import cn.wanghaomiao.xpath.exception.NoSuchFunctionException;
import cn.wanghaomiao.xpath.model.Node;
import cn.wanghaomiao.xpath.model.Predicate;
import cn.wanghaomiao.xpath.util.CommonUtil;
import cn.wanghaomiao.xpath.util.ScopeEm;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class XpathEvaluator {
    public List<Object> xpathParser(String xpath, Elements root) throws NoSuchAxisException, NoSuchFunctionException {
        if (xpath.contains("|")) {
            String[] chiXpaths;
            LinkedList<Object> rs = new LinkedList<Object>();
            for (String chiXp : chiXpaths = xpath.split("\\|")) {
                if (chiXp.length() <= 0) continue;
                rs.addAll(this.evaluate(chiXp.trim(), root));
            }
            return rs;
        }
        return this.evaluate(xpath, root);
    }

    public List<Node> getXpathNodeTree(String xpath) {
        NodeTreeBuilderStateMachine st = new NodeTreeBuilderStateMachine();
        while (st.state != NodeTreeBuilderStateMachine.BuilderState.END) {
            st.state.parser(st, xpath.toCharArray());
        }
        return st.context.xpathTr;
    }

    public List<Object> evaluate(String xpath, Elements root) throws NoSuchAxisException, NoSuchFunctionException {
        List<Object> res = new LinkedList<Object>();
        Elements context = root;
        List<Node> xpathNodes = this.getXpathNodeTree(xpath);
        for (int i = 0; i < xpathNodes.size(); ++i) {
            String value;
            String key;
            Node n = xpathNodes.get(i);
            LinkedList<Element> contextTmp = new LinkedList<Element>();
            if (n.getScopeEm() == ScopeEm.RECURSIVE || n.getScopeEm() == ScopeEm.CURREC) {
                if (n.getTagName().startsWith("@")) {
                    for (Element e : context) {
                        key = n.getTagName().substring(1);
                        if (key.equals("*")) {
                            res.add(e.attributes().toString());
                        } else {
                            value = e.attr(key);
                            if (StringUtils.isNotBlank((String)value)) {
                                res.add(value);
                            }
                        }
                        for (Element dep : e.getAllElements()) {
                            if (key.equals("*")) {
                                res.add(dep.attributes().toString());
                                continue;
                            }
                            String value2 = dep.attr(key);
                            if (!StringUtils.isNotBlank((String)value2)) continue;
                            res.add(value2);
                        }
                    }
                    continue;
                }
                if (n.getTagName().endsWith("()")) {
                    res.add(context.text());
                    continue;
                }
                Elements searchRes = context.select(n.getTagName());
                for (Element e : searchRes) {
                    Element filterR = this.filter(e, n);
                    if (filterR == null) continue;
                    contextTmp.add(filterR);
                }
                context = new Elements(contextTmp);
                continue;
            }
            if (n.getTagName().startsWith("@")) {
                for (Element e : context) {
                    key = n.getTagName().substring(1);
                    if (key.equals("*")) {
                        res.add(e.attributes().toString());
                        continue;
                    }
                    value = e.attr(key);
                    if (!StringUtils.isNotBlank((String)value)) continue;
                    res.add(value);
                }
                continue;
            }
            if (n.getTagName().endsWith("()")) {
                res = (List)this.callFunc(n.getTagName().substring(0, n.getTagName().length() - 2), context);
                continue;
            }
            for (Element e : context) {
                Elements filterScope = e.children();
                if (StringUtils.isNotBlank((String)n.getAxis())) {
                    filterScope = this.getAxisScopeEls(n.getAxis(), e);
                }
                for (Element chi : filterScope) {
                    Element fchi = this.filter(chi, n);
                    if (fchi == null) continue;
                    contextTmp.add(fchi);
                }
            }
            context = new Elements(contextTmp);
            if (i != xpathNodes.size() - 1) continue;
            res.addAll(contextTmp);
        }
        return res;
    }

    public Element filter(Element e, Node node) throws NoSuchFunctionException, NoSuchAxisException {
        if (node.getTagName().equals("*") || node.getTagName().equals(e.nodeName())) {
            if (node.getPredicate() != null) {
                Predicate p = node.getPredicate();
                if (p.getOpEm() == null) {
                    if (p.getValue().matches("\\d+") && this.getElIndex(e) == Integer.parseInt(p.getValue())) {
                        return e;
                    }
                    if (p.getValue().endsWith("()") && ((Boolean)this.callFilterFunc(p.getValue().substring(0, p.getValue().length() - 2), e)).booleanValue()) {
                        return e;
                    }
                } else if (p.getLeft().matches("[^/]+\\(\\)")) {
                    Object filterRes = p.getOpEm().excute(this.callFilterFunc(p.getLeft().substring(0, p.getLeft().length() - 2), e).toString(), p.getRight());
                    if (filterRes instanceof Boolean && ((Boolean)filterRes).booleanValue()) {
                        return e;
                    }
                    if (filterRes instanceof Integer && e.siblingIndex() == Integer.parseInt(filterRes.toString())) {
                        return e;
                    }
                } else if (p.getLeft().startsWith("@")) {
                    String lValue = e.attr(p.getLeft().substring(1));
                    Object filterRes = p.getOpEm().excute(lValue, p.getRight());
                    if (((Boolean)filterRes).booleanValue()) {
                        return e;
                    }
                } else {
                    LinkedList<Element> eltmp = new LinkedList<Element>();
                    eltmp.add(e);
                    List<Object> rstmp = this.evaluate(p.getLeft(), new Elements(eltmp));
                    if (((Boolean)p.getOpEm().excute(StringUtils.join(rstmp, (String)""), p.getRight())).booleanValue()) {
                        return e;
                    }
                }
            } else {
                return e;
            }
        }
        return null;
    }

    public Elements getAxisScopeEls(String axis, Element e) throws NoSuchAxisException {
        try {
            String functionName = CommonUtil.getJMethodNameFromStr(axis);
            Method axisSelector = AxisSelector.class.getMethod(functionName, Element.class);
            return (Elements)axisSelector.invoke((Object)SingletonProducer.getInstance().getAxisSelector(), e);
        }
        catch (NoSuchMethodException e1) {
            throw new NoSuchAxisException("this axis is not supported,plase use other instead of '" + axis + "'");
        }
        catch (Exception e2) {
            throw new NoSuchAxisException(e2.getMessage());
        }
    }

    public Object callFunc(String funcname, Elements context) throws NoSuchFunctionException {
        try {
            Method function = Functions.class.getMethod(funcname, Elements.class);
            return function.invoke((Object)SingletonProducer.getInstance().getFunctions(), context);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchFunctionException("This function is not supported");
        }
        catch (Exception e1) {
            throw new NoSuchFunctionException(e1.getMessage());
        }
    }

    public Object callFilterFunc(String funcname, Element el) throws NoSuchFunctionException {
        try {
            Method function = Functions.class.getMethod(funcname, Element.class);
            return function.invoke((Object)SingletonProducer.getInstance().getFunctions(), el);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchFunctionException("This function is not supported");
        }
        catch (Exception et) {
            throw new NoSuchFunctionException(et.getMessage());
        }
    }

    public int getElIndex(Element e) {
        if (e != null) {
            return CommonUtil.getElIndexInSameTags(e);
        }
        return 1;
    }
}

