/*
 * Decompiled with CFR 0.152.
 */
package cn.okayj.util.lineartree;

import cn.okayj.util.lineartree.NodeFlatIndex;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataNode<S> {
    public static final int CHILD_POSITION_HEADER = 1;
    public static final int CHILD_POSITION_MIDDLE = 2;
    public static final int CHILD_POSITION_FOOTER = 3;
    protected S mSource;
    protected boolean mVisibility = true;
    protected boolean mIsFolded = false;
    private DataNode mParentNode;
    private NodeFlatIndex mNodeFlatIndex;
    protected List<DataNode> mHeaderChildNodes = new ArrayList<DataNode>();
    protected List<DataNode> mChildNodes = new ArrayList<DataNode>();
    protected List<DataNode> mFooterChildNodes = new ArrayList<DataNode>();
    private int mDescendantSize = 0;
    private int mDescendantVisibleSize = 0;

    private void setParentNode(DataNode parentNode) {
        this.mParentNode = parentNode;
    }

    public S getSource() {
        return this.mSource;
    }

    public void setSource(S source) {
        this.mSource = source;
    }

    public DataNode getParentNode() {
        return this.mParentNode;
    }

    int getDescendantVisibleSize() {
        return this.mDescendantVisibleSize;
    }

    public final void addHeaderNode(DataNode headerNode) {
        this.addHeaderNode(this.mHeaderChildNodes.size(), headerNode);
    }

    public final void addHeaderNode(int position, DataNode headerNode) {
        headerNode.setParentNode(this);
        this.mHeaderChildNodes.add(position, headerNode);
        this.onInternalChildAdd(headerNode, 1);
    }

    public final void addChildNode(DataNode childNode) {
        this.addChildNode(this.mChildNodes.size(), childNode);
    }

    public final void addChildNode(int position, DataNode childNode) {
        childNode.setParentNode(this);
        this.mChildNodes.add(position, childNode);
        this.onInternalChildAdd(childNode, 2);
    }

    public final void addFooterNode(DataNode footerNode) {
        this.addFooterNode(this.mFooterChildNodes.size(), footerNode);
    }

    public final void addFooterNode(int position, DataNode footerNode) {
        footerNode.setParentNode(this);
        this.mFooterChildNodes.add(position, footerNode);
        this.onInternalChildAdd(footerNode, 3);
    }

    public final int removeHeaderNode(DataNode dataNode) {
        int position = this.mHeaderChildNodes.indexOf(dataNode);
        if (position >= 0) {
            this.removeHeaderNode(position);
        }
        return position;
    }

    public final DataNode removeHeaderNode(int position) {
        DataNode dataNode = this.mHeaderChildNodes.remove(position);
        this.onInternalChildRemove(dataNode, 2);
        return dataNode;
    }

    public final int removeChildNode(DataNode dataNode) {
        int position = this.mChildNodes.indexOf(dataNode);
        if (position >= 0) {
            this.removeChildNode(position);
        }
        return position;
    }

    public final DataNode removeChildNode(int position) {
        DataNode dataNode = this.mChildNodes.remove(position);
        this.onInternalChildRemove(dataNode, 2);
        return dataNode;
    }

    public final int removeFooterNode(DataNode dataNode) {
        int position = this.mFooterChildNodes.indexOf(dataNode);
        if (position >= 0) {
            this.removeFooterNode(position);
        }
        return position;
    }

    public final DataNode removeFooterNode(int position) {
        DataNode dataNode = this.mFooterChildNodes.remove(position);
        this.onInternalChildRemove(dataNode, 2);
        return dataNode;
    }

    public final void removeFromParent() {
        if (this.mParentNode != null) {
            this.mParentNode.removeNode(this);
        }
    }

    public final void removeNode(DataNode dataNode) {
        if (this.removeHeaderNode(dataNode) < 0 && this.removeChildNode(dataNode) < 0) {
            this.removeFooterNode(dataNode);
        }
    }

    public final int getFlatSize() {
        return this.mDescendantSize + 1;
    }

    public final int getVisibleFlatSize() {
        return DataNode.calculateVisibleFlatSize(this.mVisibility, this.mIsFolded, this.mDescendantVisibleSize);
    }

    public int getHeaderNodeSize() {
        return this.mHeaderChildNodes.size();
    }

    public DataNode getHeaderNode(int position) {
        return this.mHeaderChildNodes.get(position);
    }

    public int getChildNodeSize() {
        return this.mChildNodes.size();
    }

    public DataNode getChildNode(int position) {
        return this.mChildNodes.get(position);
    }

    public int getFooterNodeSize() {
        return this.mFooterChildNodes.size();
    }

    public DataNode getFooterNode(int position) {
        return this.mFooterChildNodes.get(position);
    }

    public final boolean isVisible() {
        return this.mVisibility;
    }

    public final boolean isFold() {
        return this.mIsFolded;
    }

    public final void setVisibility(boolean visibility) {
        if (this.mVisibility != visibility) {
            int visibleFlatSizeBefore = this.getVisibleFlatSize();
            this.mVisibility = visibility;
            if (this.mParentNode != null) {
                int visibleFlatSizeAfter = this.getVisibleFlatSize();
                int deltaDescendantFlatSize = 0;
                int deltaVisibleDescendantFlatSize = 0;
                deltaVisibleDescendantFlatSize = visibleFlatSizeAfter - visibleFlatSizeBefore;
                this.mParentNode.notifyDescendantStateChange(deltaDescendantFlatSize, deltaVisibleDescendantFlatSize);
            }
            DataNode preVisibleSibling = this.getPreVisibleSibling(this);
            this.notifyVisibilityChangeToFlatIndex(preVisibleSibling, this, visibility);
        }
    }

    public final void setIsFolded(boolean isFolded) {
        if (this.mIsFolded != isFolded) {
            int visibleFlatSizeBefore = this.getVisibleFlatSize();
            this.mIsFolded = isFolded;
            if (this.mParentNode != null) {
                int visibleFlatSizeAfter = this.getVisibleFlatSize();
                int deltaDescendantFlatSize = 0;
                int deltaVisibleDescendantFlatSize = 0;
                deltaVisibleDescendantFlatSize = visibleFlatSizeAfter - visibleFlatSizeBefore;
                this.mParentNode.notifyDescendantStateChange(deltaDescendantFlatSize, deltaVisibleDescendantFlatSize);
            }
            this.notifyFoldStateChangeToFlatIndex(this, isFolded);
        }
    }

    public NodeFlatIndex getFlatIndex() {
        if (this.mNodeFlatIndex == null) {
            this.mNodeFlatIndex = new NodeFlatIndex(this);
        }
        return this.mNodeFlatIndex;
    }

    protected void onChildNodeAdded(DataNode addedNode, int position) {
    }

    protected void onChildNodeRemoved(DataNode removedNode, int position) {
    }

    void invalidateFlatIndex() {
        if (this.mNodeFlatIndex != null) {
            this.mNodeFlatIndex = null;
        }
    }

    private void onInternalChildAdd(DataNode dataNode, int position) {
        int deltaDescendantSize = dataNode.getFlatSize();
        int deltaVisibleDescendantSize = dataNode.getVisibleFlatSize();
        this.notifyDescendantStateChange(deltaDescendantSize, deltaVisibleDescendantSize);
        ArrayList<DataNode> nodes = new ArrayList<DataNode>();
        nodes.addAll(this.mHeaderChildNodes);
        nodes.addAll(this.mChildNodes);
        nodes.addAll(this.mFooterChildNodes);
        int index = nodes.indexOf(dataNode);
        DataNode preVisibleSibling = this.getPreVisibleSibling(dataNode);
        DataNode preSibling = null;
        if (index > 0) {
            preSibling = (DataNode)nodes.get(index - 1);
        }
        this.addSubtreeToFlatIndex(preSibling, preVisibleSibling, dataNode);
        this.onChildNodeAdded(dataNode, position);
    }

    private void onInternalChildRemove(DataNode dataNode, int position) {
        int deltaDescendantSize = -dataNode.getFlatSize();
        int deltaVisibleDescendantSize = -dataNode.getVisibleFlatSize();
        this.notifyDescendantStateChange(deltaDescendantSize, deltaVisibleDescendantSize);
        this.removeSubtreeFromFlatIndex(dataNode);
        dataNode.mParentNode = null;
        this.onChildNodeRemoved(dataNode, position);
    }

    private DataNode getPreVisibleSibling(DataNode dataNode) {
        DataNode parent = dataNode.getParentNode();
        assert (parent != null);
        ArrayList<DataNode> nodes = new ArrayList<DataNode>();
        nodes.addAll(parent.mHeaderChildNodes);
        nodes.addAll(parent.mChildNodes);
        nodes.addAll(parent.mFooterChildNodes);
        int index = nodes.indexOf(dataNode);
        DataNode preVisibleSibling = null;
        for (int i = index - 1; i >= 0 && !(preVisibleSibling = (DataNode)nodes.get(i)).isVisible(); --i) {
            preVisibleSibling = null;
        }
        return preVisibleSibling;
    }

    private void notifyDescendantStateChange(int deltaDescendantSize, int deltaVisibleDescendantSize) {
        this.mDescendantSize += deltaDescendantSize;
        this.mDescendantVisibleSize += deltaVisibleDescendantSize;
        if (this.mParentNode != null) {
            if (deltaVisibleDescendantSize != 0 && (!this.mVisibility || this.mIsFolded)) {
                deltaVisibleDescendantSize = 0;
            }
            if (deltaDescendantSize != 0 && deltaVisibleDescendantSize != 0) {
                this.mParentNode.notifyDescendantStateChange(deltaDescendantSize, deltaVisibleDescendantSize);
            }
        }
    }

    private void notifyVisibilityChangeToFlatIndex(DataNode preVisibleSibling, DataNode node, boolean currentVisibility) {
        if (this.mNodeFlatIndex != null) {
            this.mNodeFlatIndex.onNodeVisibilityChange(preVisibleSibling, node, currentVisibility);
        }
        if (this.mParentNode != null) {
            this.mParentNode.notifyVisibilityChangeToFlatIndex(preVisibleSibling, node, currentVisibility);
        }
    }

    private void notifyFoldStateChangeToFlatIndex(DataNode node, boolean currentFolded) {
        if (this.mNodeFlatIndex != null) {
            this.mNodeFlatIndex.onNodeFoldStateChange(node, currentFolded);
        }
        if (this.mParentNode != null) {
            this.mParentNode.notifyFoldStateChangeToFlatIndex(node, currentFolded);
        }
    }

    private void addSubtreeToFlatIndex(DataNode preSibling, DataNode preVisibleSibling, DataNode subtree) {
        if (this.mNodeFlatIndex != null) {
            this.mNodeFlatIndex.addSubtree(preSibling, preVisibleSibling, subtree);
        }
        if (this.mParentNode != null) {
            this.mParentNode.addSubtreeToFlatIndex(preSibling, preVisibleSibling, subtree);
        }
    }

    private void removeSubtreeFromFlatIndex(DataNode subtree) {
        if (this.mNodeFlatIndex != null) {
            this.mNodeFlatIndex.removeFlatNodes(subtree);
        }
        if (this.mParentNode != null) {
            this.mParentNode.removeSubtreeFromFlatIndex(subtree);
        }
    }

    public static int calculateVisibleFlatSize(boolean visibility, boolean isFolded, int descendantVisibleSize) {
        if (!visibility) {
            return 0;
        }
        if (isFolded) {
            return 1;
        }
        return descendantVisibleSize + 1;
    }
}

