/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.mi;

import android.content.Context;
import android.os.Build;
import cn.leancloud.AVLogger;
import cn.leancloud.AVManifestUtils;
import cn.leancloud.AVMiPushMessageReceiver;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.xiaomi.mipush.sdk.MiPushClient;

public class AVMixPushManager {
    private static final AVLogger LOGGER = LogUtil.getLogger(AVMixPushManager.class);
    public static final String MIXPUSH_PROFILE = "deviceProfile";
    public static String miDeviceProfile = "";
    public static Class miPushReceiverClazz = AVMiPushMessageReceiver.class;

    public static void registerXiaomiPush(Context context, String miAppId, String miAppKey) {
        AVMixPushManager.registerXiaomiPush(context, miAppId, miAppKey, "");
    }

    public static void registerXiaomiPush(Context context, String miAppId, String miAppKey, Class customizedReceiver) {
        AVMixPushManager.registerXiaomiPush(context, miAppId, miAppKey, "", customizedReceiver);
    }

    public static void registerXiaomiPush(Context context, String miAppId, String miAppKey, String profile) {
        AVMixPushManager.registerXiaomiPush(context, miAppId, miAppKey, profile, null);
    }

    public static void registerXiaomiPush(Context context, String miAppId, String miAppKey, String profile, Class customizedReceiver) {
        if (null == context) {
            throw new IllegalArgumentException("context cannot be null.");
        }
        if (StringUtil.isEmpty((String)miAppId)) {
            throw new IllegalArgumentException("miAppId cannot be null.");
        }
        if (StringUtil.isEmpty((String)miAppKey)) {
            throw new IllegalArgumentException("miAppKey cannot be null.");
        }
        if (null != customizedReceiver) {
            miPushReceiverClazz = customizedReceiver;
        }
        if (!AVMixPushManager.isXiaomiPhone()) {
            AVMixPushManager.printErrorLog("register error, current device is not a xiaomi phone!");
        }
        if (!AVMixPushManager.checkXiaomiManifest(context)) {
            AVMixPushManager.printErrorLog("register error, mainifest is incomplete(receiver not found: " + miPushReceiverClazz.getSimpleName() + ")!");
            return;
        }
        miDeviceProfile = profile;
        MiPushClient.registerPush((Context)context, (String)miAppId, (String)miAppKey);
        LOGGER.d("finished to register mi push");
    }

    public static void registerXiaomiPush(Context context, String miAppId, String miAppKey, String profile, boolean isInternationalVendor) {
        AVMixPushManager.registerXiaomiPush(context, miAppId, miAppKey, profile, isInternationalVendor, null);
    }

    public static void registerXiaomiPush(Context context, String miAppId, String miAppKey, String profile, boolean isInternationalVendor, Class customizedReceiver) {
        AVMiPushMessageReceiver.setInternationalVendor(isInternationalVendor);
        AVMixPushManager.registerXiaomiPush(context, miAppId, miAppKey, profile, customizedReceiver);
    }

    private static boolean isXiaomiPhone() {
        String phoneManufacturer = Build.MANUFACTURER;
        return !StringUtil.isEmpty((String)phoneManufacturer) && phoneManufacturer.toLowerCase().contains("xiaomi");
    }

    private static boolean checkXiaomiManifest(Context context) {
        try {
            return AVManifestUtils.checkReceiver((Context)context, (Class)miPushReceiverClazz);
        }
        catch (Exception e) {
            LOGGER.d(e.getMessage());
            return false;
        }
    }

    private static void printErrorLog(String error) {
        if (!StringUtil.isEmpty((String)error)) {
            LOGGER.e(error);
        }
    }
}

