/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.hms;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Looper;
import cn.leancloud.AVException;
import cn.leancloud.AVHMSMessageService;
import cn.leancloud.AVInstallation;
import cn.leancloud.AVLogger;
import cn.leancloud.AVManifestUtils;
import cn.leancloud.callback.AVCallback;
import cn.leancloud.callback.SaveCallback;
import cn.leancloud.convertor.ObserverBuilder;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.huawei.agconnect.config.AGConnectServicesConfig;
import com.huawei.hmf.tasks.OnCompleteListener;
import com.huawei.hmf.tasks.Task;
import com.huawei.hms.aaid.HmsInstanceId;
import com.huawei.hms.push.HmsMessaging;
import com.huawei.hms.support.api.push.service.HmsMsgService;
import io.reactivex.Observer;

public class AVMixPushManager {
    private static final AVLogger LOGGER = LogUtil.getLogger(AVMixPushManager.class);
    public static final String MIXPUSH_PROFILE = "deviceProfile";
    public static String hwDeviceProfile = "";
    static Class hwMessageServiceClazz = AVHMSMessageService.class;

    public static void registerHMSPush(Application application) {
        AVMixPushManager.registerHMSPush(application, "");
    }

    public static void registerHMSPush(Application application, String profile) {
        AVMixPushManager.registerHMSPush(application, profile, null);
    }

    public static void registerHMSPush(Application application, String profile, Class customMessageServiceClazz) {
        if (null == application) {
            throw new IllegalArgumentException("[HMS] context cannot be null.");
        }
        if (!AVMixPushManager.isHuaweiPhone()) {
            AVMixPushManager.printErrorLog("[HMS] register error, is not huawei phone!");
            return;
        }
        if (null != customMessageServiceClazz) {
            hwMessageServiceClazz = customMessageServiceClazz;
        }
        if (!AVMixPushManager.checkHuaweiManifest((Context)application)) {
            AVMixPushManager.printErrorLog("[HMS] register error, mainifest is incomplete!");
            return;
        }
        hwDeviceProfile = profile;
        LOGGER.d("[HMS] start register HMS push");
    }

    public static void connectHMS(Activity activity) {
        if (null == activity) {
            throw new IllegalArgumentException("[HMS] activity cannot be null.");
        }
        String appId = AGConnectServicesConfig.fromContext((Context)activity).getString("client/app_id");
        AVMixPushManager.connectHMS(activity, appId);
    }

    public static void connectHMS(final Activity activity, final String huaweiAppId) {
        if (null == activity) {
            throw new IllegalArgumentException("[HMS] activity cannot be null.");
        }
        if (Looper.getMainLooper() == Looper.myLooper()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String token = HmsInstanceId.getInstance((Context)activity).getToken(huaweiAppId, "HCM");
                        LOGGER.d("found HMS appId: " + huaweiAppId + ", token: " + token);
                        AVHMSMessageService.updateAVInstallation(token);
                    }
                    catch (Exception ex) {
                        LOGGER.w("failed to get hms token. cause: " + ex.getMessage());
                    }
                }
            }).start();
        } else {
            try {
                String token = HmsInstanceId.getInstance((Context)activity).getToken(huaweiAppId, "HCM");
                LOGGER.d("found HMS appId: " + huaweiAppId + ", token: " + token);
                AVHMSMessageService.updateAVInstallation(token);
            }
            catch (Exception ex) {
                LOGGER.w("failed to get hms token. cause: " + ex.getMessage());
            }
        }
    }

    public static void turnOnHMSPush(Context context, final AVCallback<Void> callback) {
        HmsMessaging.getInstance((Context)context).turnOnPush().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(){

            public void onComplete(Task<Void> task) {
                if (task.isSuccessful()) {
                    callback.internalDone(null);
                } else {
                    callback.internalDone(new AVException((Throwable)task.getException()));
                }
            }
        });
    }

    public static void turnOffHMSPush(Context context, final AVCallback<Void> callback) {
        HmsMessaging.getInstance((Context)context).turnOffPush().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(){

            public void onComplete(Task<Void> task) {
                if (task.isSuccessful()) {
                    callback.internalDone(null);
                } else {
                    callback.internalDone(new AVException((Throwable)task.getException()));
                }
            }
        });
    }

    public static void unRegisterMixPush() {
        AVInstallation installation = AVInstallation.getCurrentInstallation();
        String vendor = installation.getString("vendor");
        if (!StringUtil.isEmpty((String)vendor)) {
            installation.put("vendor", (Object)"lc");
            installation.saveInBackground().subscribe((Observer)ObserverBuilder.buildSingleObserver((SaveCallback)new SaveCallback(){

                public void done(AVException e) {
                    if (null != e) {
                        AVMixPushManager.printErrorLog("unRegisterMixPush error!");
                    } else {
                        LOGGER.d("Registration canceled successfully!");
                    }
                }
            }));
        }
    }

    private static boolean isHuaweiPhone() {
        String phoneBrand = Build.BRAND;
        try {
            return phoneBrand.equalsIgnoreCase("huawei") || phoneBrand.equalsIgnoreCase("honor");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean checkHuaweiManifest(Context context) {
        boolean result = false;
        try {
            result = AVManifestUtils.checkPermission((Context)context, (String)"android.permission.INTERNET") && AVManifestUtils.checkPermission((Context)context, (String)"android.permission.ACCESS_NETWORK_STATE") && AVManifestUtils.checkPermission((Context)context, (String)"android.permission.ACCESS_WIFI_STATE") && AVManifestUtils.checkPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") && AVManifestUtils.checkService((Context)context, HmsMsgService.class) && AVManifestUtils.checkService((Context)context, (Class)hwMessageServiceClazz);
        }
        catch (Exception e) {
            LOGGER.d(e.getMessage());
        }
        return result;
    }

    private static void printErrorLog(String error) {
        if (!StringUtil.isEmpty((String)error)) {
            LOGGER.e(error);
        }
    }
}

