/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVLogger;
import cn.leancloud.push.AndroidNotificationManager;
import cn.leancloud.utils.LogUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import java.util.Map;

public class AVFirebaseMessagingService
extends FirebaseMessagingService {
    private static final AVLogger LOGGER = LogUtil.getLogger(AVFirebaseMessagingService.class);

    public void onMessageReceived(RemoteMessage remoteMessage) {
        Map data = remoteMessage.getData();
        if (null == data) {
            return;
        }
        LOGGER.d("received message from: " + remoteMessage.getFrom() + ", payload: " + data.toString());
        try {
            JSONObject jsonObject = JSON.parseObject((String)((String)data.get("payload")));
            if (null != jsonObject) {
                String channel = jsonObject.getString("_channel");
                String action = jsonObject.getString("action");
                AndroidNotificationManager androidNotificationManager = AndroidNotificationManager.getInstance();
                androidNotificationManager.processGcmMessage(channel, action, jsonObject.toJSONString());
            }
        }
        catch (Exception ex) {
            LOGGER.e("failed to parse push data.", (Throwable)ex);
        }
    }

    public void onDeletedMessages() {
        super.onDeletedMessages();
    }
}

