/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVException;
import cn.leancloud.AVInstallation;
import cn.leancloud.AVLogger;
import cn.leancloud.callback.SaveCallback;
import cn.leancloud.convertor.ObserverBuilder;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdService;
import io.reactivex.Observer;

public class AVFirebaseInstanceIDService
extends FirebaseInstanceIdService {
    private static final AVLogger LOGGER = LogUtil.getLogger(AVFirebaseInstanceIDService.class);
    private final String VENDOR = "fcm";

    public void onTokenRefresh() {
        String refreshedToken = FirebaseInstanceId.getInstance().getToken();
        this.sendRegistrationToServer(refreshedToken);
        LOGGER.d("refreshed token: " + refreshedToken);
    }

    private void sendRegistrationToServer(String refreshedToken) {
        if (StringUtil.isEmpty((String)refreshedToken)) {
            return;
        }
        AVInstallation installation = AVInstallation.getCurrentInstallation();
        if (!"fcm".equals(installation.getString("vendor"))) {
            installation.put("vendor", (Object)"fcm");
        }
        if (!refreshedToken.equals(installation.getString("registrationId"))) {
            installation.put("registrationId", (Object)refreshedToken);
        }
        installation.saveInBackground().subscribe((Observer)ObserverBuilder.buildSingleObserver((SaveCallback)new SaveCallback(){

            public void done(AVException e) {
                if (null != e) {
                    LOGGER.e("failed to update installation.", (Throwable)e);
                } else {
                    LOGGER.d("succeed to update installation.");
                }
            }
        }));
        LOGGER.d("FCM registration success! registrationId=" + refreshedToken);
    }
}

