/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.impl;

import cn.leancloud.EngineAppConfiguration;
import cn.leancloud.core.AppRouter;
import cn.leancloud.service.AppAccessEndpoint;
import cn.leancloud.utils.StringUtil;
import io.reactivex.Observable;

public class EnvFirstAppRouter
extends AppRouter {
    private boolean isLocalEngineCall = false;

    public Observable<AppAccessEndpoint> fetchServerHostsInBackground(String appId) {
        String apiServer = EngineAppConfiguration.getEnvOrProperty("LEANCLOUD_API_SERVER");
        String apiPort = EngineAppConfiguration.getEnvOrProperty("LEANCLOUD_APP_PORT");
        if (!StringUtil.isEmpty((String)apiServer)) {
            AppAccessEndpoint accessEndpoint = new AppAccessEndpoint();
            accessEndpoint.setTtl(36000L);
            accessEndpoint.setStatServer(apiServer);
            accessEndpoint.setRtmRouterServer(apiServer);
            accessEndpoint.setPushServer(apiServer);
            if (this.isLocalEngineCall) {
                accessEndpoint.setEngineServer("http://0.0.0.0:" + apiPort);
            } else {
                accessEndpoint.setEngineServer(apiServer);
            }
            accessEndpoint.setApiServer(apiServer);
            return Observable.just((Object)accessEndpoint);
        }
        return super.fetchServerHostsInBackground(appId);
    }

    public void setLocalEngineCallEnabled(boolean enabled) {
        this.isLocalEngineCall = enabled;
    }
}

