/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.EngineRequestContext;
import cn.leancloud.LeanEngine;
import cn.leancloud.UnauthException;
import cn.leancloud.core.GeneralRequestSignature;
import cn.leancloud.utils.StringUtil;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class RequestAuth {
    private static final Logger logger = LogManager.getLogger(RequestAuth.class);
    static final String ANDROID_AFFILIATED_SUFFIX = "ax-sig-1";
    static final String SIGN_MASTERKEY_SUFFIX = "master";
    public static final String ATTRIBUTE_KEY = "requestAuth";
    public static final String USER_KEY = "authUser";
    private String appId;
    private String appKey;
    private String masterKey;
    private String prod;
    private String sessionToken;
    private String sign;

    public static void auth(HttpServletRequest req) throws UnauthException {
        RequestAuth info = new RequestAuth(req);
        logger.debug("request auth: {}", (Object)info);
        if (info.getAppId() == null) {
            throw new UnauthException();
        }
        if (LeanEngine.getAppId().equals(info.getAppId()) && (LeanEngine.getAppKey().equals(info.getAppKey()) || LeanEngine.getMasterKey().equals(info.getAppKey()) || LeanEngine.getMasterKey().equals(info.getMasterKey()))) {
            if (LeanEngine.getMasterKey().equals(info.getMasterKey())) {
                req.setAttribute("authMasterKey", (Object)true);
            }
            req.setAttribute(ATTRIBUTE_KEY, (Object)info);
            return;
        }
        if (info.getSign() != null) {
            String[] split = info.getSign().split(",");
            String sign = split[0];
            String ts = split[1];
            String master = null;
            if (split.length > 2) {
                master = split[2];
            }
            if (ANDROID_AFFILIATED_SUFFIX.equals(master)) {
                String androidKey = LeanEngine.getAndroidKey();
                if (!StringUtil.isEmpty((String)androidKey)) {
                    String computedSign = GeneralRequestSignature.requestSign((String)androidKey, (long)Long.parseLong(ts), (String)ANDROID_AFFILIATED_SUFFIX);
                    if (info.getSign().equals(computedSign)) {
                        req.setAttribute(ATTRIBUTE_KEY, (Object)info);
                        return;
                    }
                }
            } else {
                boolean useMasterKey = SIGN_MASTERKEY_SUFFIX.equals(master);
                String computedSign = GeneralRequestSignature.requestSign((long)Long.parseLong(ts), (boolean)useMasterKey);
                if (info.getSign().equals(computedSign)) {
                    req.setAttribute(ATTRIBUTE_KEY, (Object)info);
                    return;
                }
            }
        }
        throw new UnauthException();
    }

    private RequestAuth(HttpServletRequest req) {
        if (req.getContentType() == null || !req.getContentType().startsWith("text/plain")) {
            this.appId = this.getHeaders(req, "x-lc-id", "x-avoscloud-application-id", "x-uluru-application-id");
            this.appKey = this.getHeaders(req, "x-lc-key", "x-avoscloud-application-key", "x-uluru-application-key");
            this.masterKey = this.getHeaders(req, "x-avoscloud-master-key", "x-uluru-master-key");
            if (this.appKey != null && this.appKey.indexOf(",master") > 0) {
                this.masterKey = this.appKey.substring(0, this.appKey.indexOf(",master"));
                this.appKey = null;
            }
            this.prod = this.getHeaders(req, "x-lc-prod", "x-avoscloud-application-production", "x-uluru-application-production");
            if ("false".equals(this.prod)) {
                this.prod = "0";
            }
            this.sessionToken = this.getHeaders(req, "x-lc-session", "x-uluru-session-token", "x-avoscloud-session-token");
            this.sign = this.getHeaders(req, "x-lc-sign", "x-avoscloud-request-sign");
            String remoteAddress = this.getHeaders(req, "x-real-ip", "x-forwarded-for");
            if (StringUtil.isEmpty((String)remoteAddress)) {
                remoteAddress = req.getRemoteAddr();
            }
            EngineRequestContext.setSessionToken(this.sessionToken);
            EngineRequestContext.setRemoteAddress(remoteAddress);
        }
    }

    private String getHeaders(HttpServletRequest req, String ... headers) {
        for (String header : headers) {
            String result = req.getHeader(header);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getMasterKey() {
        return this.masterKey;
    }

    public String getProd() {
        return this.prod;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public String getSign() {
        return this.sign;
    }

    public String toString() {
        return "RequestAuth [appId=" + this.appId + ", appKey=" + (this.appKey != null ? this.appKey.substring(0, 2) + "..." : null) + ", masterKey=" + (this.masterKey != null ? this.masterKey.substring(0, 2) + "..." : null) + ", prod=" + this.prod + ", sessionToken=" + this.sessionToken + ", sign=" + this.sign + "]";
    }
}

