/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVLogger;
import cn.leancloud.AVObject;
import cn.leancloud.AVUser;
import cn.leancloud.BeforeUpdateHookHandlerInfo;
import cn.leancloud.EndpointParser;
import cn.leancloud.EngineFunction;
import cn.leancloud.EngineFunctionHandlerInfo;
import cn.leancloud.EngineFunctionParam;
import cn.leancloud.EngineFunctionParamInfo;
import cn.leancloud.EngineHook;
import cn.leancloud.EngineHookHandlerInfo;
import cn.leancloud.EngineHookType;
import cn.leancloud.IMHook;
import cn.leancloud.IMHookHandlerInfo;
import cn.leancloud.InvalidParameterException;
import cn.leancloud.ResponseUtil;
import cn.leancloud.ops.Utils;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public abstract class EngineHandlerInfo {
    private static final AVLogger LOGGER = LogUtil.getLogger(EngineHandlerInfo.class);
    static final String OBJECT = "object";
    static final String USER = "user";
    final Method handlerMethod;
    final String endPoint;
    final List<EngineFunctionParamInfo> methodParameterList;
    final Class<?> returnType;
    final String hookClass;

    public EngineHandlerInfo(String endpoint, Method handlerMethod, List<EngineFunctionParamInfo> params, Class<?> returnType) {
        this(endpoint, handlerMethod, params, returnType, null);
    }

    public EngineHandlerInfo(String endpoint, Method handlerMethod, List<EngineFunctionParamInfo> params, Class<?> returnType, String hookClass) {
        this.handlerMethod = handlerMethod;
        this.endPoint = endpoint;
        this.methodParameterList = params;
        this.returnType = returnType;
        this.hookClass = hookClass;
    }

    public Method getHandlerMethod() {
        return this.handlerMethod;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public List<EngineFunctionParamInfo> getParamList() {
        return this.methodParameterList;
    }

    public Object execute(HttpServletRequest request, boolean rpcCall) throws Exception {
        StringBuilder sb = new StringBuilder();
        String line = null;
        BufferedReader reader = request.getReader();
        while ((line = reader.readLine()) != null) {
            sb.append(line);
        }
        String requestBody = sb.toString();
        LOGGER.d("request body: " + requestBody);
        Object returnValue = null;
        Object params = this.parseParams(requestBody);
        returnValue = this.methodParameterList.size() == 0 ? this.handlerMethod.invoke(null, new Object[0]) : (params.getClass().isArray() ? this.handlerMethod.invoke(null, (Object[])params) : this.handlerMethod.invoke(null, params));
        returnValue = this.wrapperResponse(returnValue, requestBody, rpcCall);
        return returnValue;
    }

    public abstract Object parseParams(String var1) throws InvalidParameterException;

    public Object wrapperResponse(Object returnValue, String requestBody, boolean rpcCall) {
        JSONObject result = new JSONObject();
        result.put("result", Utils.getParsedObject((Object)returnValue, (boolean)true));
        if (!rpcCall) {
            return JSON.parse((String)ResponseUtil.filterResponse(result.toJSONString()));
        }
        return result;
    }

    public static EngineHandlerInfo getEngineHandlerInfo(Method method, EngineFunction function) {
        String functionName = StringUtil.isEmpty((String)function.value()) ? method.getName() : function.value();
        LinkedList<EngineFunctionParamInfo> params = new LinkedList<EngineFunctionParamInfo>();
        Annotation[][] annotationMatrix = method.getParameterAnnotations();
        Class<?>[] paramTypesArray = method.getParameterTypes();
        for (int index = 0; index < paramTypesArray.length; ++index) {
            Annotation[] array = annotationMatrix[index];
            if (array.length == 0) {
                LOGGER.w("Parameters not annotated correctly for EngineFunction:" + functionName);
                continue;
            }
            for (Annotation an : array) {
                if (!(an instanceof EngineFunctionParam)) continue;
                params.add(new EngineFunctionParamInfo(paramTypesArray[index], ((EngineFunctionParam)an).value()));
            }
        }
        return new EngineFunctionHandlerInfo(functionName, method, (List<EngineFunctionParamInfo>)params, (Class)method.getReturnType());
    }

    public static EngineHandlerInfo getEngineHandlerInfo(Method method, EngineHook hook) {
        LinkedList<EngineFunctionParamInfo> params = new LinkedList<EngineFunctionParamInfo>();
        params.add(new EngineFunctionParamInfo("_User".equals(hook.className()) ? AVUser.class : AVObject.class, OBJECT));
        if (EngineHookType.beforeUpdate.equals((Object)hook.type())) {
            return new BeforeUpdateHookHandlerInfo(EndpointParser.getInternalEndpoint(hook.className(), hook.type()), method, (List<EngineFunctionParamInfo>)params, null, hook.className());
        }
        return new EngineHookHandlerInfo(EndpointParser.getInternalEndpoint(hook.className(), hook.type()), method, (List<EngineFunctionParamInfo>)params, null, hook.className());
    }

    public static EngineHandlerInfo getEngineHandlerInfo(Method method, IMHook hook) {
        LinkedList<EngineFunctionParamInfo> params = new LinkedList<EngineFunctionParamInfo>();
        params.add(new EngineFunctionParamInfo(Map.class, OBJECT));
        return new IMHookHandlerInfo(hook.type().toString(), method, (List<EngineFunctionParamInfo>)params, (Class)Map.class);
    }
}

