/*
 * Decompiled with CFR 0.152.
 */
package jexx.template.word;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jexx.exception.IORuntimeException;
import jexx.io.FileUtil;
import jexx.io.IOUtil;
import jexx.log.Log;
import jexx.log.LogFactory;
import jexx.template.MagicTemplate;
import org.apache.poi.xwpf.usermodel.TextSegement;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

public class MagicWordTemplate
extends MagicTemplate {
    private static final Log LOG = LogFactory.get();
    private XWPFDocument document;

    public MagicWordTemplate(InputStream inputStream) {
        try {
            this.document = new XWPFDocument(inputStream);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public MagicWordTemplate(File file) {
        this(FileUtil.newBufferedInputStream((File)file));
    }

    @Override
    public void output(OutputStream outputStream) {
        try {
            Iterator itPara = this.document.getParagraphsIterator();
            while (itPara.hasNext()) {
                XWPFParagraph paragraph = (XWPFParagraph)itPara.next();
                this.replaceParagraph(paragraph);
            }
            Iterator itTable = this.document.getTablesIterator();
            while (itTable.hasNext()) {
                XWPFTable table = (XWPFTable)itTable.next();
                int rowCount = table.getNumberOfRows();
                for (int i = 0; i < rowCount; ++i) {
                    XWPFTableRow row = table.getRow(i);
                    List cells = row.getTableCells();
                    for (XWPFTableCell cell : cells) {
                        for (XWPFParagraph paragraph : cell.getParagraphs()) {
                            this.replaceParagraph(paragraph);
                        }
                    }
                }
            }
            this.document.write(outputStream);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    protected void replaceParagraph(XWPFParagraph paragraph) {
        int i;
        if (this.debug) {
            LOG.info("=====================Before optimize XWPFParagraph", new Object[0]);
            this.printParagraph(paragraph);
        }
        int macroStartPos = 0;
        int beginRunPos = 0;
        int beginCharPos = 0;
        boolean hasMacroStart = false;
        int macroEndPos = 0;
        boolean clear = false;
        boolean skipLetter = false;
        ArrayList<TextSegement> segments = new ArrayList<TextSegement>();
        ArrayList waitReplaceRuns = new ArrayList();
        List runs = paragraph.getRuns();
        for (i = 0; i < runs.size(); ++i) {
            XWPFRun run = (XWPFRun)runs.get(i);
            String runText = run.getText(0);
            for (int charPos = 0; charPos < runText.length(); ++charPos) {
                char c = runText.charAt(charPos);
                if (skipLetter) {
                    skipLetter = false;
                    continue;
                }
                if (hasMacroStart) {
                    if (c == this.macroEnd.charAt(macroEndPos)) {
                        if (macroEndPos + 1 < this.macroEnd.length()) {
                            ++macroEndPos;
                        } else {
                            TextSegement segment = new TextSegement();
                            segment.setBeginRun(beginRunPos);
                            segment.setBeginChar(beginCharPos);
                            segment.setEndRun(i);
                            segment.setEndChar(charPos);
                            segments.add(segment);
                            clear = true;
                        }
                    } else if (macroEndPos > 0) {
                        clear = true;
                    }
                } else if (c == this.macroStart.charAt(macroStartPos)) {
                    if (macroStartPos == 0) {
                        beginRunPos = i;
                        beginCharPos = charPos;
                    }
                    if (macroStartPos + 1 < this.macroStart.length()) {
                        ++macroStartPos;
                    } else {
                        hasMacroStart = true;
                    }
                } else if (macroStartPos > 0) {
                    clear = true;
                } else if (c == this.escapeChar) {
                    skipLetter = true;
                }
                if (!clear) continue;
                clear = false;
                macroStartPos = 0;
                beginRunPos = 0;
                beginCharPos = 0;
                hasMacroStart = false;
                macroEndPos = 0;
            }
        }
        for (i = segments.size() - 1; i >= 0; --i) {
            TextSegement segment = (TextSegement)segments.get(i);
            String text = paragraph.getText(segment);
            if (segment.getBeginRun() == segment.getEndRun()) {
                waitReplaceRuns.add(runs.get(segment.getBeginRun()));
                continue;
            }
            if (segment.getBeginRun() >= segment.getEndRun()) continue;
            XWPFRun startRun = (XWPFRun)runs.get(segment.getBeginRun());
            startRun.setText(text, segment.getBeginChar());
            XWPFRun endRun = (XWPFRun)runs.get(segment.getEndRun());
            if (segment.getEndRun() < endRun.getTextPosition()) {
                endRun.setText(endRun.getText(segment.getEndChar()), segment.getEndChar());
            } else {
                endRun.setText("", 0);
            }
            for (int pos = segment.getBeginRun() + 1; pos < segment.getEndRun(); ++pos) {
                ((XWPFRun)runs.get(pos)).setText("", 0);
            }
            waitReplaceRuns.add(startRun);
        }
        if (this.debug) {
            LOG.info("=====================After optimize XWPFParagraph", new Object[0]);
            this.printParagraph(paragraph);
        }
        for (XWPFRun waitReplaceRun : waitReplaceRuns) {
            this.replaceRun(paragraph, waitReplaceRun);
        }
        if (this.debug) {
            LOG.info("=====================Finally", new Object[0]);
            this.printParagraph(paragraph);
        }
    }

    protected void printParagraph(XWPFParagraph paragraph) {
        List runs = paragraph.getRuns();
        for (int i = 0; i < runs.size(); ++i) {
            XWPFRun run = (XWPFRun)runs.get(i);
            LOG.info("{}===>{}", new Object[]{i, run.getText(0)});
        }
    }

    protected void replaceRun(XWPFParagraph paragraph, XWPFRun run) {
        String text = run.getText(0);
        String replace = this.parse(text);
        run.setText(replace, 0);
    }

    @Override
    public void doClose() {
        IOUtil.closeQuietly((Closeable)this.document);
    }
}

