/*
 * Decompiled with CFR 0.152.
 */
package jexx.template.excel;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jexx.exception.IORuntimeException;
import jexx.io.FastByteArrayOutputStream;
import jexx.io.FileUtil;
import jexx.io.IOUtil;
import jexx.log.Log;
import jexx.log.LogFactory;
import jexx.poi.ExcelWriter;
import jexx.template.MagicTemplate;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class MagicExcelTemplate
extends MagicTemplate {
    private static final Log LOG = LogFactory.get();
    private Workbook workbook;

    public MagicExcelTemplate(Workbook workbook) {
        this.workbook = workbook;
    }

    public MagicExcelTemplate(InputStream inputStream) {
        try {
            this.workbook = WorkbookFactory.create((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtil.closeQuietly((Closeable)inputStream);
        }
    }

    public MagicExcelTemplate(File file) {
        this(FileUtil.newBufferedInputStream((File)file));
    }

    @Override
    public void output(OutputStream outputStream) {
        try {
            for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
                Sheet sheet = this.workbook.getSheetAt(i);
                if (sheet.getLastRowNum() <= 0) continue;
                for (int j = 0; j <= sheet.getLastRowNum(); ++j) {
                    Row row = sheet.getRow(j);
                    for (int k = 0; k < row.getLastCellNum(); ++k) {
                        Cell cell = row.getCell(k);
                        if (cell == null) continue;
                        this.replaceCell(cell);
                    }
                }
            }
            this.workbook.write(outputStream);
            outputStream.flush();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    protected void replaceCell(Cell cell) {
        if (cell.getCellTypeEnum() == CellType.STRING) {
            String text = cell.getStringCellValue();
            String replace = this.parse(text);
            cell.setCellValue(replace);
        }
    }

    public ExcelWriter toExcelWriter() {
        try (FastByteArrayOutputStream outputStream = new FastByteArrayOutputStream();){
            this.output((OutputStream)outputStream);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            ExcelWriter excelWriter = new ExcelWriter((InputStream)inputStream, true);
            return excelWriter;
        }
    }

    @Override
    public void doClose() {
        IOUtil.closeQuietly((Closeable)this.workbook);
    }
}

