/*
 * Decompiled with CFR 0.152.
 */
package jexx.template;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import jexx.bean.BeanUtil;
import jexx.io.FileUtil;
import jexx.io.IOUtil;
import jexx.template.StringTemplateParser;
import jexx.template.property.ITemplateProperty;
import jexx.template.property.impl.DefaultTemplateProperty;
import jexx.util.MapUtil;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.extractor.ExtractorFactory;
import org.apache.poi.openxml4j.opc.OPCPackage;

public abstract class MagicTemplate
implements Closeable {
    protected boolean debug;
    public static final String DEFAULT_MACRO_START = "${";
    public static final String DEFAULT_MACRO_END = "}";
    protected String macroStart = "${";
    protected String macroEnd = "}";
    protected char escapeChar = (char)92;
    private StringTemplateParser parser;
    protected Map<String, ITemplateProperty> propertyMap = new HashMap<String, ITemplateProperty>();

    public void put(String name, Object value) {
        DefaultTemplateProperty property = new DefaultTemplateProperty(name, value);
        this.propertyMap.put(name, property);
    }

    public void put(ITemplateProperty property) {
        this.propertyMap.put(property.getName(), property);
    }

    public void putMap(Map<String, Object> attributes) {
        if (MapUtil.isNotEmpty(attributes)) {
            attributes.forEach(this::put);
        }
    }

    public void putBean(Object bean) {
        this.putMap(BeanUtil.toMap((Object)bean));
    }

    protected String parse(String text) {
        if (this.parser == null) {
            this.parser = new StringTemplateParser();
            this.parser.setMacroStart(this.macroStart);
            this.parser.setMacroPrefix(this.macroStart.substring(0, 1));
            this.parser.setMacroEnd(this.macroEnd);
        }
        return this.parser.parse(text, s -> {
            ITemplateProperty property = this.propertyMap.get(s);
            if (property instanceof DefaultTemplateProperty) {
                DefaultTemplateProperty defaultTemplateProperty = (DefaultTemplateProperty)property;
                return defaultTemplateProperty.getValue() != null ? defaultTemplateProperty.getValue().toString() : null;
            }
            return null;
        });
    }

    public abstract void output(OutputStream var1);

    public void outputFile(File file) {
        this.output(FileUtil.newBufferedOutputStream((File)file));
    }

    public String getText() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.output(outputStream);
        byte[] buffer = outputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer);
        POIXMLTextExtractor extractor = null;
        try {
            extractor = ExtractorFactory.createExtractor((OPCPackage)OPCPackage.open((InputStream)inputStream));
            String text = extractor.getText();
            extractor.close();
            String string = text;
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtil.closeQuietly((Closeable)extractor);
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public void close() {
        this.doClose();
    }

    protected abstract void doClose();
}

