/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.writer;

import java.util.List;
import jexx.poi.cell.IMergedCell;
import jexx.poi.row.DataRow;
import jexx.poi.row.Row;
import jexx.poi.row.RowContext;
import jexx.poi.style.CellStyleMapper;
import jexx.poi.writer.SheetCellWriter;
import jexx.util.CollectionUtil;
import org.apache.poi.ss.usermodel.Sheet;

public class SheetRowWriter
extends SheetCellWriter {
    protected boolean repair = true;

    public SheetRowWriter(Sheet sheet) {
        super(sheet);
    }

    public SheetRowWriter writeRow(RowContext row, CellStyleMapper cellStyleMapper) {
        DataRow rootRow = row.getRootRow();
        if (this.repair) {
            row.repair();
        }
        this.doRecursionRow(rootRow, cellStyleMapper);
        return this;
    }

    private void doRecursionRow(Row row, CellStyleMapper cellStyleMapper) {
        List<IMergedCell> cells = row.getCells();
        for (IMergedCell cell : cells) {
            this.writeCell(cell, cellStyleMapper);
        }
        List<Row> children = row.getChildren();
        if (CollectionUtil.isNotEmpty(children)) {
            for (Row child : children) {
                this.doRecursionRow(child, cellStyleMapper);
            }
        }
    }

    public void setRepair(boolean repair) {
        this.repair = repair;
    }
}

