/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.writer;

import java.util.ArrayList;
import java.util.List;
import jexx.poi.cell.AbstractCell;
import jexx.poi.cell.ICell;
import jexx.poi.cell.ICellSupportMeta;
import jexx.poi.cell.IMergedCell;
import jexx.poi.cell.ImageCell;
import jexx.poi.cell.MergedCell;
import jexx.poi.cell.SingleCell;
import jexx.poi.style.CellStyleMapper;
import jexx.poi.style.IWrapCellStyle;
import jexx.poi.util.CellOperateUtil;
import jexx.poi.util.DataValidationUtil;
import jexx.poi.writer.AbstractSheetWriter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class SheetCellWriter
extends AbstractSheetWriter {
    private List<ICell> cellList = new ArrayList<ICell>();
    protected boolean supportValid = true;

    public SheetCellWriter(Sheet sheet) {
        super(sheet);
    }

    public void setSupportValid(boolean supportValid) {
        this.supportValid = supportValid;
    }

    public SheetCellWriter writeCell(IMergedCell cell) {
        return this.writeCell(cell, null);
    }

    public SheetCellWriter writeCell(IMergedCell cell, CellStyleMapper cellStyleMapper) {
        if (cellStyleMapper != null) {
            IWrapCellStyle cellStyle = cellStyleMapper.warpCellStyle(cell);
            if (cell instanceof AbstractCell) {
                ((AbstractCell)cell).setCellStyle(cellStyle);
            }
        }
        this.cellList.add(cell);
        return this;
    }

    public SheetCellWriter flush() {
        boolean isMerge = false;
        for (ICell cell : this.cellList) {
            if (cell instanceof SingleCell) {
                this.handleCell((SingleCell)cell);
                continue;
            }
            if (cell instanceof MergedCell) {
                MergedCell mergedCell = (MergedCell)cell;
                if (mergedCell.isMerged()) {
                    isMerge = true;
                    CellOperateUtil.mergeCellsByUnsafe(this.sheet, mergedCell.getFirstRowNum(), mergedCell.getFirstColumnNum(), mergedCell.getLastRowNum(), mergedCell.getLastColumnNum());
                }
                this.handleCell(mergedCell);
                continue;
            }
            if (!(cell instanceof ImageCell)) continue;
            ImageCell imageCell = (ImageCell)cell;
            if (imageCell.isMerged()) {
                isMerge = true;
                CellOperateUtil.mergeCellsByUnsafe(this.sheet, imageCell.getFirstRowNum(), imageCell.getFirstColumnNum(), imageCell.getLastRowNum(), imageCell.getLastColumnNum());
            }
            this.handleCell(imageCell);
        }
        if (isMerge) {
            this.sheet.validateMergedRegions();
        }
        this.cellList.clear();
        return this;
    }

    protected void handleCell(SingleCell cell) {
        Row sRow = this.getOrCreateRow(cell.getFirstRowNum());
        Cell sCell = this.getOrCreateCell(sRow, cell.getFirstColumnNum());
        if (cell.getCellStyle() != null) {
            this.setCellStyle(sCell, cell.getCellStyle());
        }
        this.setCellValue(sCell, cell.getLabel());
        this.addValidationData(cell);
    }

    protected void handleCell(MergedCell cell) {
        Row sRow = this.getOrCreateRow(cell.getFirstRowNum());
        Cell sCell = this.getOrCreateCell(sRow, cell.getFirstColumnNum());
        this.setCellStyle(cell.getFirstRowNum(), cell.getFirstColumnNum(), cell.getLastRowNum(), cell.getLastColumnNum(), cell.getCellStyle());
        this.setCellValue(sCell, cell.getLabel());
        this.addValidationData(cell);
    }

    protected void handleCell(ImageCell cell) {
        this.addPicture(cell.getFirstRowNum(), cell.getFirstColumnNum(), cell.getLastRowNum(), cell.getLastColumnNum(), cell.getValue(), cell.getPictureType());
    }

    protected void addValidationData(ICellSupportMeta cell) {
        if (this.supportValid && cell != null && cell.supportMeta() && cell.isValid()) {
            int startRowNum = cell.getFirstRowNum();
            int startColumnNum = cell.getFirstColumnNum();
            String formula = cell.createNameName();
            DataValidation dataValidation = DataValidationUtil.createValidation(this.sheet, formula, startRowNum, startRowNum, startColumnNum, startColumnNum);
            this.sheet.addValidationData(dataValidation);
        }
    }

    @Override
    public void autoSizeColumn(int ... columnNums) {
        this.flush();
        super.autoSizeColumn(columnNums);
    }
}

