/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.writer;

import java.util.List;
import jexx.log.Log;
import jexx.log.LogFactory;
import jexx.poi.cell.MergedCell;
import jexx.poi.header.Headers;
import jexx.poi.header.ICustomHeader;
import jexx.poi.header.IDataHeader;
import jexx.poi.row.DataRow;
import jexx.poi.row.Row;
import jexx.poi.row.RowContext;
import jexx.util.CollectionUtil;

public abstract class AbstractRowWriter {
    private static final Log LOG = LogFactory.get(AbstractRowWriter.class);

    protected void writeCustom(RowContext context, Headers headers, int itemIndex) {
        List<ICustomHeader> customHeaders = headers.getCustomHeaders();
        if (CollectionUtil.isEmpty(customHeaders)) {
            return;
        }
        this.doWriteCustom(context, context.getRootRow(), customHeaders, itemIndex);
    }

    protected void doWriteCustom(RowContext context, DataRow row, List<ICustomHeader> customHeaders, int itemIndex) {
        for (ICustomHeader customHeader : customHeaders) {
            IDataHeader sameLevelHeader = customHeader.getSameLevelHeader();
            if (sameLevelHeader == null) {
                if (row != context.getRootRow()) continue;
                Object value = customHeader.getCustomValue(context.getRootRow(), itemIndex);
                MergedCell cell = new MergedCell((Row)row, customHeader.getStartColumnNum(), customHeader.getEndColumnNum(), value, customHeader.getDataCellStyle());
                context.addCell(row, cell);
                continue;
            }
            if (!row.hasHeaderDataInChild(sameLevelHeader.getStartColumnNum()) || !CollectionUtil.isNotEmpty(row.getChildren())) continue;
            for (int i = 0; i < row.getChildren().size(); ++i) {
                Row r = row.getChildren().get(i);
                if (!(r instanceof DataRow)) continue;
                DataRow dataRow = (DataRow)r;
                Object value = customHeader.getCustomValue(dataRow, i);
                MergedCell cell = new MergedCell((Row)dataRow, customHeader.getStartColumnNum(), customHeader.getEndColumnNum(), value, customHeader.getDataCellStyle());
                context.addCell(dataRow, cell);
            }
        }
        List<Row> children = row.getChildren();
        if (CollectionUtil.isNotEmpty(children)) {
            for (int i = 0; i < row.getChildren().size(); ++i) {
                Row r = row.getChildren().get(i);
                if (!(r instanceof DataRow)) continue;
                this.doWriteCustom(context, (DataRow)r, customHeaders, itemIndex);
            }
        }
    }
}

