/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.util;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import jexx.io.IOUtil;
import jexx.poi.exception.POIException;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class WorkbookUtil {
    private static boolean isSetMinInflateRatio = false;

    public static Workbook createBook(boolean isXlsx) {
        Object workbook = isXlsx ? new XSSFWorkbook() : new HSSFWorkbook();
        return workbook;
    }

    public static Workbook createBook(File excelFile) {
        return WorkbookUtil.createBook(excelFile, null);
    }

    public static Workbook createBook(File excelFile, String password) {
        try {
            WorkbookUtil.setMinInflateRatio();
            return WorkbookFactory.create((File)excelFile, (String)password);
        }
        catch (Exception e) {
            throw new POIException(e);
        }
    }

    public static Workbook createBook(InputStream in) {
        return WorkbookUtil.createBook(in, null, true);
    }

    public static Workbook createBook(InputStream in, boolean closeAfterRead) {
        return WorkbookUtil.createBook(in, null, closeAfterRead);
    }

    public static Workbook createBook(InputStream in, String password, boolean closeAfterRead) {
        try {
            WorkbookUtil.setMinInflateRatio();
            Workbook workbook = WorkbookFactory.create((InputStream)IOUtil.toMarkSupportStream((InputStream)in), (String)password);
            return workbook;
        }
        catch (Exception e) {
            throw new POIException(e);
        }
        finally {
            if (closeAfterRead) {
                IOUtil.closeQuietly((Closeable)in);
            }
        }
    }

    public static void setMinInflateRatio(double ratio) {
        isSetMinInflateRatio = true;
        ZipSecureFile.setMinInflateRatio((double)ratio);
    }

    public static void setMinInflateRatio() {
        if (!isSetMinInflateRatio) {
            WorkbookUtil.setMinInflateRatio(0.009);
        }
    }
}

