/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.util;

import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.util.Locale;
import jexx.log.Log;
import jexx.log.LogFactory;
import jexx.util.FontUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class SheetUtil {
    private static final Log LOG = LogFactory.get(SheetUtil.class);
    private static final char defaultChar = '0';
    private static final double fontHeightMultiple = 2.0;
    private static final FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
    public static final String SONG_TI = "\u5b8b\u4f53";
    private static boolean hasSongTi = FontUtil.hasFontFamilyName((String)"\u5b8b\u4f53");

    public static double getColumnWidth(Sheet sheet, int columnNum, boolean useMergedCells) {
        return SheetUtil.getColumnWidth(sheet, columnNum, useMergedCells, sheet.getFirstRowNum() + 1, sheet.getLastRowNum() + 1);
    }

    public static double getColumnWidth(Sheet sheet, int columnNum, boolean useMergedCells, int firstRowNum, int lastRowNum) {
        DataFormatter formatter = new DataFormatter();
        FormulaEvaluator formulaEvaluator = sheet.getWorkbook().getCreationHelper().createFormulaEvaluator();
        double defaultCharWidth = SheetUtil.getDefaultCharWidth(sheet.getWorkbook());
        double width = -1.0;
        for (int rowIdx = firstRowNum; rowIdx <= lastRowNum; ++rowIdx) {
            Row row = sheet.getRow(rowIdx - 1);
            if (row == null) continue;
            double cellWidth = SheetUtil.getColumnWidthForRow(row, columnNum, defaultCharWidth, formatter, formulaEvaluator, useMergedCells);
            width = Math.max(width, cellWidth);
        }
        return width;
    }

    private static double getColumnWidthForRow(Row row, int columnNum, double defaultCharWidth, DataFormatter formatter, FormulaEvaluator formulaEvaluator, boolean useMergedCells) {
        if (row == null) {
            return -1.0;
        }
        Cell cell = row.getCell(columnNum - 1);
        if (cell == null) {
            return -1.0;
        }
        return SheetUtil.getCellWidth(cell, defaultCharWidth, formatter, formulaEvaluator, useMergedCells);
    }

    public static double getDefaultCharWidth(Workbook wb) {
        Font defaultFont = wb.getFontAt((short)0);
        String x = String.valueOf('0');
        AttributedString str = new AttributedString(x);
        SheetUtil.copyAttributes(defaultFont, str, 0, 1);
        TextLayout layout = new TextLayout(str.getIterator(), fontRenderContext);
        return layout.getAdvance();
    }

    private static void copyAttributes(Font font, AttributedString str, int startIdx, int endIdx) {
        str.addAttribute(TextAttribute.FAMILY, hasSongTi ? SONG_TI : font.getFontName(), startIdx, endIdx);
        str.addAttribute(TextAttribute.SIZE, font.getFontHeightInPoints());
        if (font.getBold()) {
            str.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, startIdx, endIdx);
        }
        if (font.getItalic()) {
            str.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, startIdx, endIdx);
        }
        if (font.getUnderline() == 1) {
            str.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, startIdx, endIdx);
        }
    }

    public static double getCellWidth(Cell cell, double defaultCharWidth, DataFormatter formatter, FormulaEvaluator formulaEvaluator, boolean useMergedCells) {
        Sheet sheet = cell.getSheet();
        Workbook wb = sheet.getWorkbook();
        Row row = cell.getRow();
        int column = cell.getColumnIndex();
        int colspan = 1;
        for (CellRangeAddress region : sheet.getMergedRegions()) {
            if (!region.isInRange(row.getRowNum(), column)) continue;
            if (!useMergedCells) {
                return -1.0;
            }
            cell = row.getCell(region.getFirstColumn());
            colspan = 1 + region.getLastColumn() - region.getFirstColumn();
        }
        CellStyle style = cell.getCellStyle();
        CellType cellType = cell.getCellTypeEnum();
        if (cellType == CellType.FORMULA) {
            cellType = cell.getCachedFormulaResultTypeEnum();
        }
        Font font = wb.getFontAt(style.getFontIndex());
        double width = -1.0;
        if (cellType == CellType.STRING) {
            String[] lines;
            RichTextString rt = cell.getRichStringCellValue();
            for (String line : lines = rt.getString().split("\\n")) {
                String txt = line + '0';
                AttributedString str = new AttributedString(txt);
                SheetUtil.copyAttributes(font, str, 0, txt.length());
                width = SheetUtil.getCellWidth(defaultCharWidth, colspan, style, width, str);
            }
        } else {
            String sval = null;
            if (cellType == CellType.NUMERIC) {
                try {
                    sval = formatter.formatCellValue(cell, formulaEvaluator);
                }
                catch (Exception e) {
                    sval = String.valueOf(cell.getNumericCellValue());
                }
            } else if (cellType == CellType.BOOLEAN) {
                sval = String.valueOf(cell.getBooleanCellValue()).toUpperCase(Locale.ROOT);
            }
            if (sval != null) {
                String txt = sval + '0';
                AttributedString str = new AttributedString(txt);
                SheetUtil.copyAttributes(font, str, 0, txt.length());
                width = SheetUtil.getCellWidth(defaultCharWidth, colspan, style, width, str);
            }
        }
        return width;
    }

    private static double getCellWidth(double defaultCharWidth, int colspan, CellStyle style, double minWidth, AttributedString str) {
        Rectangle2D bounds;
        TextLayout layout = new TextLayout(str.getIterator(), fontRenderContext);
        if (style.getRotation() != 0) {
            AffineTransform trans = new AffineTransform();
            trans.concatenate(AffineTransform.getRotateInstance((double)style.getRotation() * 2.0 * Math.PI / 360.0));
            trans.concatenate(AffineTransform.getScaleInstance(1.0, 2.0));
            bounds = layout.getOutline(trans).getBounds();
        } else {
            bounds = layout.getBounds();
        }
        double frameWidth = bounds.getX() + bounds.getWidth();
        return Math.max(minWidth, frameWidth / (double)colspan / defaultCharWidth + (double)style.getIndention());
    }

    static {
        if (!hasSongTi) {
            LOG.warn("this environment has no font with \"\u5b8b\u4f53\", so jexx-poi may be failed to auto column", new Object[0]);
        }
    }
}

