/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.util;

import java.util.ArrayList;
import java.util.List;
import jexx.poi.util.CellOperateUtil;
import jexx.util.Assert;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellUtil;

public class RowOperationUtil {
    public static void writeData(Row row, Iterable<?> data) {
        int i = 0;
        for (Object obj : data) {
            Cell cell = row.createCell(i++);
            CellOperateUtil.setCellValue(cell, obj);
        }
    }

    public static void writeMeta(Row row, String name, List<?> valueMetas) {
        int i = 0;
        Cell cell = row.createCell(i++);
        CellOperateUtil.setCellValue(cell, name);
        for (Object value : valueMetas) {
            cell = row.createCell(i++);
            CellOperateUtil.setCellValue(cell, value);
        }
    }

    public static List<Object> readRow(Row row) {
        return RowOperationUtil.readRow(row, 1);
    }

    public static List<Object> readRow(Row row, int startColumnNum) {
        Assert.isTrue((startColumnNum > 0 ? 1 : 0) != 0);
        if (row == null) {
            return new ArrayList<Object>();
        }
        return RowOperationUtil.readRow(row, startColumnNum, row.getLastCellNum() + 1);
    }

    public static List<Object> readRow(Row row, int startColumnNum, int endColumnNum) {
        if (row == null) {
            return new ArrayList<Object>();
        }
        Assert.isTrue((startColumnNum > 0 && endColumnNum >= startColumnNum ? 1 : 0) != 0, (String)"rowNum={},startColumnNum={},endColumnNum={}", (Object[])new Object[]{row.getRowNum() + 1, startColumnNum, endColumnNum});
        int lastCellNum = row.getLastCellNum() + 1;
        lastCellNum = lastCellNum <= endColumnNum ? lastCellNum : endColumnNum;
        ArrayList<Object> data = new ArrayList<Object>(lastCellNum);
        for (int i = startColumnNum; i <= lastCellNum; ++i) {
            Cell cell = row.getCell(i - 1);
            data.add(CellOperateUtil.getCellValue(cell));
        }
        return data;
    }

    public static Row getRow(Sheet sheet, int rowNum) {
        return RowOperationUtil.getRow(rowNum, sheet);
    }

    public static Row getRow(int rowNum, Sheet sheet) {
        return CellUtil.getRow((int)(rowNum - 1), (Sheet)sheet);
    }

    public static int getLastRowNum(Sheet sheet) {
        return sheet.getLastRowNum() + 1;
    }

    public static Row createRow(Sheet sheet, int rowNum) {
        return sheet.createRow(rowNum - 1);
    }
}

