/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.util;

import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class DataValidationUtil {
    public static DataValidation createValidation(Sheet sheet, String formula, int firstRowNum, int lastRowNum, int firstColNum, int lastColNum) {
        HSSFDataValidation dataValidation;
        int firstRowIndex = firstRowNum - 1;
        int lastRowIndex = lastRowNum - 1;
        int firstColIndex = firstColNum - 1;
        int lastColIndex = lastColNum - 1;
        if (sheet instanceof XSSFSheet) {
            XSSFDataValidationHelper dvHelper = new XSSFDataValidationHelper((XSSFSheet)sheet);
            XSSFDataValidationConstraint dvConstraint = (XSSFDataValidationConstraint)dvHelper.createFormulaListConstraint(formula);
            CellRangeAddressList regions = new CellRangeAddressList(firstRowIndex, lastRowIndex, firstColIndex, lastColIndex);
            dataValidation = dvHelper.createValidation((DataValidationConstraint)dvConstraint, regions);
        } else {
            DVConstraint constraint = DVConstraint.createFormulaListConstraint((String)formula);
            CellRangeAddressList regions = new CellRangeAddressList(firstRowIndex, lastRowIndex, firstColIndex, lastColIndex);
            dataValidation = new HSSFDataValidation(regions, (DataValidationConstraint)constraint);
        }
        return dataValidation;
    }
}

