/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.row;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jexx.poi.cell.FormulaCellValue;
import jexx.poi.cell.IMergedCell;
import jexx.poi.cell.MergedCell;
import jexx.poi.header.row.HeaderRowContext;
import jexx.poi.row.DataRow;
import jexx.poi.row.Row;
import jexx.poi.row.VirtualRow;
import jexx.poi.style.IWrapCellStyle;
import jexx.poi.util.CellOperateUtil;
import jexx.util.CollectionUtil;
import jexx.util.StringUtil;

public class RowContext {
    private DataRow rootRow;
    private HeaderRowContext headerRowContext;
    private Map<IMergedCell, DataRow> cellRowMap;
    private Map<Integer, List<IMergedCell>> headerCellMap;

    public RowContext(DataRow rootRow, HeaderRowContext headerRowContext) {
        this.rootRow = rootRow;
        if (headerRowContext != null) {
            this.rootRow.setHeaderRow(headerRowContext.getRootHeaderRow());
        }
        this.headerRowContext = headerRowContext;
        this.cellRowMap = new HashMap<IMergedCell, DataRow>(64);
        this.headerCellMap = new HashMap<Integer, List<IMergedCell>>(64);
    }

    public RowContext(DataRow rootRow) {
        this(rootRow, null);
    }

    public void addCell(DataRow row, IMergedCell cell) {
        this.cellRowMap.put(cell, row);
        List headerCells = this.headerCellMap.computeIfAbsent(cell.getFirstColumnNum(), s -> new ArrayList());
        headerCells.add(cell);
        row.addCell(cell);
    }

    public void addCell(IMergedCell cell) {
        this.addCell(this.rootRow, cell);
    }

    public DataRow addDataRowAt(DataRow parent, int rowHeight) {
        return parent.addDataRow(rowHeight);
    }

    public DataRow addDataRowAt(DataRow parent) {
        return this.addDataRowAt(parent, 1);
    }

    public DataRow addDataRowAt(int rowHeight) {
        return this.addDataRowAt(this.rootRow, rowHeight);
    }

    public DataRow addDataRowAt() {
        return this.addDataRowAt(1);
    }

    public VirtualRow appendVirtualRowAt(DataRow row) {
        assert (this.rootRow != row);
        return row.parentRow.appendVirtualRowAt(row);
    }

    public VirtualRow addVirtualRowAt(DataRow row) {
        return row.addVirtualRow(1);
    }

    public IMergedCell getCell(IMergedCell cell, int columnNum) {
        DataRow row = this.cellRowMap.get(cell);
        return row != null ? row.getCellByColumnNum(columnNum) : null;
    }

    public void repair() {
        this.rootRow.repair();
    }

    public List<IMergedCell> getChildrenCellByColumnNum(DataRow row, int columnNum) {
        return row.getCellsByColumnNum(columnNum);
    }

    public FormulaCellValue sum(DataRow row, String columnNo) {
        return this.sum(row, CellOperateUtil.toColumnNum(columnNo));
    }

    public FormulaCellValue sum(DataRow row, int columnNum) {
        return this.calculateFormula(row, columnNum, "SUM");
    }

    public FormulaCellValue calculateFormula(DataRow row, int columnNum, String expression) {
        List<IMergedCell> cells = this.getChildrenCellByColumnNum(row, columnNum);
        if (CollectionUtil.isEmpty(cells)) {
            return null;
        }
        String columnLabel = CellOperateUtil.toColumnLabel(columnNum);
        ArrayList<String> formulas = new ArrayList<String>();
        int f1 = 0;
        int f2 = 0;
        for (IMergedCell cell : cells) {
            if (f1 == 0) {
                f1 = cell.getFirstRowNum();
                f2 = cell.getLastRowNum();
                continue;
            }
            assert (cell.getFirstRowNum() > f2);
            if (cell.getFirstRowNum() == f2 + 1) {
                f2 = cell.getLastRowNum();
                continue;
            }
            formulas.add(StringUtil.format((String)"{}{}:{}{}", (Object[])new Object[]{columnLabel, f1, columnLabel, f2}));
            f1 = cell.getFirstRowNum();
            f2 = cell.getLastRowNum();
        }
        formulas.add(StringUtil.format((String)"{}{}:{}{}", (Object[])new Object[]{columnLabel, f1, columnLabel, f2}));
        StringBuilder stringBuilder = new StringBuilder(expression.concat("("));
        for (int i = 0; i < formulas.size(); ++i) {
            stringBuilder.append(i == 0 ? "" : ",").append((String)formulas.get(i));
        }
        stringBuilder.append(")");
        return new FormulaCellValue(stringBuilder.toString());
    }

    public int getStartRowNum() {
        return this.rootRow.getStartRowNum();
    }

    public int getEndRowNum() {
        return this.rootRow.getEndRowNum();
    }

    public DataRow getRootRow() {
        return this.rootRow;
    }

    public List<IMergedCell> getHeaderCells(int columnNum) {
        return this.headerCellMap.get(columnNum);
    }

    public HeaderRowContext getHeaderRowContext() {
        return this.headerRowContext;
    }

    public static RowContext createRow(int rowNum, int columnNum, List<?> rowData, IWrapCellStyle cellStyle) {
        DataRow row = new DataRow(rowNum);
        RowContext rowContext = new RowContext(row);
        if (CollectionUtil.isNotEmpty(rowData)) {
            for (int i = 0; i < rowData.size(); ++i) {
                MergedCell cell = new MergedCell((Row)row, columnNum + i, columnNum + i, rowData.get(i), cellStyle);
                rowContext.addCell(row, cell);
            }
        }
        return rowContext;
    }
}

