/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.row;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jexx.poi.cell.IMergedCell;
import jexx.poi.row.DataRow;
import jexx.poi.row.RowTypeEnum;
import jexx.util.Assert;
import jexx.util.CollectionUtil;

public abstract class Row {
    protected int startRowNum;
    protected int endRowNum;
    protected int firstColumnNum = -1;
    protected int lastColumnNum = -1;
    protected List<IMergedCell> cells = new CopyOnWriteArrayList<IMergedCell>();
    protected DataRow parentRow;
    protected List<Row> children = new CopyOnWriteArrayList<Row>();
    protected Row nextRow;

    public abstract RowTypeEnum getRowType();

    protected void addCell(IMergedCell cell) {
        assert (cell.getRow() == this);
        this.cells.add(cell);
        if (this.firstColumnNum == -1) {
            this.firstColumnNum = cell.getFirstColumnNum();
            this.lastColumnNum = cell.getLastColumnNum();
        } else {
            this.firstColumnNum = Math.min(this.firstColumnNum, cell.getFirstColumnNum());
            this.lastColumnNum = Math.max(this.lastColumnNum, cell.getLastColumnNum());
        }
    }

    protected void expandRow(Row row, int endNum) {
        assert (row.getStartRowNum() <= endNum);
        if (row.getEndRowNum() >= endNum) {
            return;
        }
        int rowCount = endNum - row.getEndRowNum();
        row.setEndRowNum(endNum);
        for (Row nextRow = row.getNextRow(); nextRow != null; nextRow = nextRow.getNextRow()) {
            nextRow.raiseRowNum(rowCount);
        }
        if (row.getParentRow() != null) {
            row.expandRow(row.getParentRow(), endNum);
        }
    }

    protected int findNextRowNumInChildren() {
        int maxRowNum = this.endRowNum;
        if (CollectionUtil.isNotEmpty(this.children)) {
            Row child = this.children.get(this.children.size() - 1);
            Assert.isTrue((child.getEndRowNum() >= maxRowNum ? 1 : 0) != 0);
            maxRowNum = child.getEndRowNum() + 1;
        }
        return maxRowNum;
    }

    protected void raiseRowNum(int rowCount) {
        this.startRowNum += rowCount;
        this.endRowNum += rowCount;
        if (CollectionUtil.isNotEmpty(this.children)) {
            for (Row r : this.children) {
                r.raiseRowNum(rowCount);
            }
        }
    }

    public boolean hasRow(Row row) {
        if (CollectionUtil.isNotEmpty(this.children)) {
            return this.children.stream().anyMatch(s -> s == row);
        }
        return false;
    }

    public List<IMergedCell> getCells() {
        return this.cells;
    }

    public int getStartRowNum() {
        return this.startRowNum;
    }

    protected void setStartRowNum(int startRowNum) {
        this.startRowNum = startRowNum;
    }

    public int getEndRowNum() {
        return this.endRowNum;
    }

    protected void setEndRowNum(int endRowNum) {
        this.endRowNum = endRowNum;
    }

    public Row getParentRow() {
        return this.parentRow;
    }

    public void setParentRow(DataRow parentRow) {
        this.parentRow = parentRow;
    }

    public List<Row> getChildren() {
        return this.children;
    }

    public Row getNextRow() {
        return this.nextRow;
    }

    protected void setNextRow(Row row) {
        this.nextRow = row;
    }

    public int getFirstColumnNum() {
        return this.firstColumnNum;
    }

    public int getLastColumnNum() {
        return this.lastColumnNum;
    }
}

