/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.read;

import java.util.ArrayList;
import java.util.List;
import jexx.poi.cell.IMergedCell;
import jexx.poi.cell.MergedCell;
import jexx.poi.read.AbstractSheetReader;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class SheetCellReader
extends AbstractSheetReader {
    public SheetCellReader(Sheet sheet) {
        super(sheet);
    }

    protected List<IMergedCell> readCellsAtOneRow(int rowNum, int startColumnNum, int endColumnNum) {
        Row row = this.getRow(rowNum);
        if (row == null) {
            return null;
        }
        int lastCellNum = row.getLastCellNum() + 1;
        int minColumnNum = Math.max(1, startColumnNum);
        int maxColumnNum = Math.min(lastCellNum, endColumnNum);
        ArrayList<IMergedCell> cells = new ArrayList<IMergedCell>();
        for (int i = minColumnNum; i <= maxColumnNum; ++i) {
            Cell cell = this.getCell(row, i);
            Object value = this.getCellValue(cell);
            cells.add(new MergedCell(rowNum, i, rowNum, i, value));
        }
        return cells;
    }

    protected List<IMergedCell> readCellsAtOneRow(int rowNum) {
        return this.readCellsAtOneRow(rowNum, 1, this.getLastCellNumAtOneRow(rowNum));
    }
}

