/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.read;

import jexx.poi.util.CellOperateUtil;
import jexx.poi.util.RowOperationUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public abstract class AbstractSheetReader {
    protected Sheet sheet;
    protected final int lastRowNumOfSheet;

    public AbstractSheetReader(Sheet sheet) {
        this.sheet = sheet;
        this.lastRowNumOfSheet = this.sheet.getLastRowNum() + 1;
    }

    public String getName() {
        return this.sheet.getSheetName();
    }

    protected Row getRow(int rowNum) {
        return RowOperationUtil.getRow(this.sheet, rowNum);
    }

    protected Cell getCell(Row row, int columnNum) {
        return row.getCell(columnNum - 1);
    }

    protected Object getCellValue(Cell cell) {
        return CellOperateUtil.getCellValue(cell);
    }

    protected int getLastCellNumAtOneRow(int rowNum) {
        Row row = this.getRow(rowNum);
        if (row == null) {
            return -1;
        }
        return row.getLastCellNum();
    }
}

