/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.meta.node;

import java.util.List;
import jexx.poi.meta.node.INode;
import jexx.poi.util.NameUtil;
import jexx.util.Assert;
import jexx.util.CollectionUtil;

public class TreeNode
implements INode {
    public static final String ROOT_NODE_NAME = "RooT";
    private Object value;
    private Object label;
    private TreeNode parent;
    private List<TreeNode> children;
    private boolean isRoot;
    private boolean isLeaf;

    public TreeNode(Object value) {
        this(value, value);
    }

    public TreeNode(Object value, Object label) {
        this(value, label, null, null);
    }

    public TreeNode(Object value, Object label, TreeNode parent, List<TreeNode> children) {
        Assert.notNull((Object)value);
        Assert.notNull((Object)label);
        this.value = value;
        this.label = label;
        this.parent = parent;
        this.children = children;
    }

    public static TreeNode createRootTreeNode() {
        return TreeNode.createRootTreeNode(ROOT_NODE_NAME);
    }

    public static TreeNode createRootTreeNode(String name) {
        TreeNode root = new TreeNode(name);
        root.isRoot = true;
        return root;
    }

    public String getFullValue() {
        StringBuilder valueBuilder = new StringBuilder();
        if (this.parent != null) {
            valueBuilder.append(this.parent.getFullValue()).append("_");
        }
        valueBuilder.append(this.value);
        return valueBuilder.toString();
    }

    public String getFullLabel() {
        StringBuilder labelBuilder = new StringBuilder();
        if (this.parent != null) {
            labelBuilder.append(this.parent.getFullLabel()).append("_");
        }
        labelBuilder.append(this.getLabel());
        return labelBuilder.toString();
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Object getLabel() {
        if (this.label != null && CollectionUtil.isNotEmpty(this.children)) {
            return NameUtil.replaceIllegalCharForName(this.label.toString());
        }
        return this.label;
    }

    public void setLabel(Object label) {
        this.label = label;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public List<TreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<TreeNode> children) {
        this.children = children;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean root) {
        this.isRoot = root;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean leaf) {
        this.isLeaf = leaf;
    }

    public int hashCode() {
        int code = this.getFullValue().hashCode();
        code = 31 * code;
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof TreeNode) {
            TreeNode another = (TreeNode)o;
            return this.getFullLabel().equals(another.getFullValue());
        }
        return false;
    }
}

