/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.meta;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jexx.poi.meta.AbstractMeta;
import jexx.poi.meta.aspect.ExcelMeta;
import jexx.poi.meta.aspect.ExcelMetaChildren;
import jexx.poi.meta.aspect.ExcelMetaLabel;
import jexx.poi.meta.aspect.ExcelMetaValue;
import jexx.poi.meta.node.INode;
import jexx.poi.meta.node.TreeNode;
import jexx.util.Assert;
import jexx.util.CollectionUtil;
import jexx.util.ReflectUtil;
import jexx.util.StringUtil;

public class TreeMeta
extends AbstractMeta {
    private String name;
    private TreeNode tree;
    private Map<Object, TreeNode> fullValueMap;
    private Map<Object, TreeNode> fullLabelMap;

    public TreeMeta(String name, TreeNode tree) {
        this.name = name;
        this.tree = tree;
        Assert.notNull((Object)name);
        Assert.notNull((Object)tree);
        this.fullValueMap = new HashMap<Object, TreeNode>();
        this.fullLabelMap = new HashMap<Object, TreeNode>();
        this.fillFullMap(tree, this.fullValueMap, this.fullLabelMap);
    }

    private void fillFullMap(TreeNode tree, Map<Object, TreeNode> fullValueMap, Map<Object, TreeNode> fullLabelMap) {
        fullValueMap.putIfAbsent(tree.getFullValue(), tree);
        fullLabelMap.putIfAbsent(tree.getFullLabel(), tree);
        if (CollectionUtil.isNotEmpty(tree.getChildren())) {
            for (TreeNode child : tree.getChildren()) {
                this.fillFullMap(child, fullValueMap, fullLabelMap);
            }
        }
    }

    public static <T> TreeMeta buildMetaWithAnnotation(String name, T obj) {
        return TreeMeta.buildMetaWithAnnotation(name, obj, 0);
    }

    public static <T> TreeMeta buildMetaWithAnnotation(String name, T obj, int maxLevel) {
        return TreeMeta.buildMetaWithAnnotation(name, CollectionUtil.list((Object[])new Object[]{obj}), maxLevel);
    }

    public static <T> TreeMeta buildMetaWithAnnotation(String name, List<T> list) {
        return TreeMeta.buildMetaWithAnnotation(name, list, 0);
    }

    public static <T> TreeMeta buildMetaWithAnnotation(String name, List<T> list, int maxLevel) {
        Assert.isTrue((maxLevel >= 0 ? 1 : 0) != 0);
        Assert.notEmpty(list);
        HashMap<Object, TreeNode> valueMap = new HashMap<Object, TreeNode>(16);
        HashMap<Object, TreeNode> labelMap = new HashMap<Object, TreeNode>(16);
        TreeNode root = TreeNode.createRootTreeNode(name);
        root.setChildren(new ArrayList<TreeNode>());
        for (T obj : list) {
            TreeNode child = TreeMeta.buildTreeWithAnnotation(obj, root, labelMap, valueMap, 1, maxLevel);
            root.getChildren().add(child);
        }
        TreeMeta meta = new TreeMeta(StringUtil.str((Object)root.getLabel()), root);
        meta.fullLabelMap = labelMap;
        meta.fullValueMap = valueMap;
        meta.checkNode();
        return meta;
    }

    private static TreeNode buildTreeWithAnnotation(Object obj, TreeNode parent, Map<Object, TreeNode> fullLabelMap, Map<Object, TreeNode> fullValueMap, int level, int maxLevel) {
        Object label;
        ExcelMeta excelMeta = (ExcelMeta)ReflectUtil.getAnnotationOfClass(obj.getClass(), ExcelMeta.class);
        Assert.notNull((Object)excelMeta, (String)"Object don't contain the annotation ExcelMeta", (Object[])new Object[0]);
        List valueFields = ReflectUtil.getFieldsByAnnotation(obj.getClass(), ExcelMetaValue.class);
        Assert.isTrue((valueFields.size() == 1 ? 1 : 0) != 0, (String)"Object has zero or more than one value field!", (Object[])new Object[0]);
        Field valueField = (Field)valueFields.get(0);
        Object value = ReflectUtil.getFieldValue((Object)obj, (Field)valueField);
        List labelFields = ReflectUtil.getFieldsByAnnotation(obj.getClass(), ExcelMetaLabel.class);
        if (CollectionUtil.isNotEmpty((Collection)labelFields)) {
            Field labelField = (Field)labelFields.get(0);
            label = ReflectUtil.getFieldValue((Object)obj, (Field)labelField);
        } else {
            label = value;
        }
        TreeNode tree = new TreeNode(value, label);
        tree.setLabel(label);
        tree.setParent(parent);
        if (maxLevel == 0 || level < maxLevel) {
            List childrenFields = ReflectUtil.getFieldsByAnnotation(obj.getClass(), ExcelMetaChildren.class);
            Assert.isTrue((childrenFields.size() <= 1 ? 1 : 0) != 0, (String)"Object has more than one children field!", (Object[])new Object[0]);
            if (CollectionUtil.isNotEmpty((Collection)childrenFields)) {
                Assert.isTrue((childrenFields.size() == 1 ? 1 : 0) != 0, (String)"Object has more than one children field!", (Object[])new Object[0]);
                Field childrenField = (Field)childrenFields.get(0);
                Assert.isTrue((boolean)childrenField.getType().isAssignableFrom(List.class), (String)"Children only support list!", (Object[])new Object[0]);
                Object children = ReflectUtil.getFieldValue((Object)obj, (Field)childrenField);
                if (children == null) {
                    tree.setLeaf(true);
                } else {
                    List cds = (List)children;
                    ArrayList<TreeNode> trees = new ArrayList<TreeNode>();
                    for (Object item : cds) {
                        TreeNode child = TreeMeta.buildTreeWithAnnotation(item, tree, fullLabelMap, fullValueMap, level + 1, maxLevel);
                        trees.add(child);
                    }
                    tree.setChildren(trees);
                    tree.setLeaf(false);
                }
            } else {
                tree.setLeaf(true);
            }
        } else {
            tree.setLeaf(true);
        }
        fullValueMap.putIfAbsent(tree.getFullValue(), tree);
        fullLabelMap.putIfAbsent(tree.getFullLabel(), tree);
        return tree;
    }

    public void checkNode() {
        if (this.tree != null) {
            this.doCheckName(this.tree);
        }
    }

    private void doCheckName(TreeNode node) {
        List<TreeNode> children = node.getChildren();
        if (CollectionUtil.isNotEmpty(children)) {
            HashMap<Object, TreeNode> map = new HashMap<Object, TreeNode>(children.size());
            for (TreeNode treeNode : children) {
                Assert.isNull(map.get(treeNode.getLabel()), (String)"There are same label[{}] at TreeNode[{}]", (Object[])new Object[]{treeNode.getLabel(), node.getFullLabel()});
                map.put(treeNode.getLabel(), treeNode);
                this.doCheckName(treeNode);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public INode getNodeByFullValue(Object fullValue) {
        return this.fullValueMap.get(fullValue);
    }

    @Override
    public INode getNodeByFullLabel(Object fullLabel) {
        return this.fullLabelMap.get(fullLabel);
    }

    public TreeNode getTree() {
        return this.tree;
    }
}

