/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.meta;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import jexx.exception.UtilException;
import jexx.poi.header.Headers;
import jexx.poi.meta.AbstractMetaSheet;
import jexx.poi.meta.ArrayMeta;
import jexx.poi.meta.DVConstraintType;
import jexx.poi.meta.IMeta;
import jexx.poi.meta.IMetaWriter;
import jexx.poi.meta.Metas;
import jexx.poi.meta.TreeMeta;
import jexx.poi.meta.node.INode;
import jexx.poi.meta.node.TreeNode;
import jexx.poi.util.CellOperateUtil;
import jexx.poi.util.RowOperationUtil;
import jexx.util.CollectionUtil;
import jexx.util.StringUtil;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class MetaSheetWriter
extends AbstractMetaSheet
implements IMetaWriter {
    private int rowNum = 1;

    public MetaSheetWriter(Sheet sheet) {
        this.sheet = sheet;
    }

    @Override
    public void save(Metas excelMeta) {
        List<Headers> headersList;
        this.rowNum = 1;
        List<IMeta> metas = excelMeta.getMetas();
        if (CollectionUtil.isNotEmpty(metas)) {
            for (IMeta meta : metas) {
                this.save(meta);
            }
        }
        if (CollectionUtil.isNotEmpty(headersList = excelMeta.getHeaders())) {
            for (Headers header : headersList) {
                this.saveHeaders(header);
            }
        }
    }

    private void save(IMeta meta) {
        String nameName = this.encodeNameName(meta.getName());
        if (meta instanceof ArrayMeta) {
            RowOperationUtil.writeData(this.createRow(this.sheet, this.rowNum++), CollectionUtil.list((Object[])new String[]{"__METADATA__START", "ARRAY"}));
            ArrayMeta listMeta = (ArrayMeta)meta;
            List values = listMeta.getValueMetas().stream().map(INode::getValue).collect(Collectors.toList());
            RowOperationUtil.writeMeta(this.createRow(this.sheet, this.rowNum++), nameName, values);
            List labels = listMeta.getValueMetas().stream().map(INode::getLabel).collect(Collectors.toList());
            RowOperationUtil.writeMeta(this.createRow(this.sheet, this.rowNum++), "", labels);
            Name name = this.sheet.getWorkbook().createName();
            name.setNameName(nameName);
            String formula = StringUtil.format((String)"{}!${}${}:${}${}", (Object[])new Object[]{this.sheet.getSheetName(), "B", this.rowNum - 1, CellOperateUtil.toColumnLabel(listMeta.getValueMetas().size() + 1), this.rowNum - 1});
            name.setRefersToFormula(formula);
        } else if (meta instanceof TreeMeta) {
            RowOperationUtil.writeData(this.createRow(this.sheet, this.rowNum++), CollectionUtil.list((Object[])new String[]{"__METADATA__START", "TREE"}));
            TreeMeta treeMeta = (TreeMeta)meta;
            this.writeTreeMeta(treeMeta.getTree());
        } else {
            throw new UtilException("no right meta for this meta[{}]", new Object[]{meta});
        }
        RowOperationUtil.writeData(this.createRow(this.sheet, this.rowNum++), CollectionUtil.list((Object[])new String[]{"__END__"}));
    }

    private void writeTreeMeta(TreeNode treeNode) {
        if (CollectionUtil.isNotEmpty(treeNode.getChildren())) {
            String nameName = this.encodeNameName(treeNode.getFullLabel());
            List values = treeNode.getChildren().stream().map(TreeNode::getValue).collect(Collectors.toList());
            RowOperationUtil.writeMeta(this.createRow(this.sheet, this.rowNum++), nameName, values);
            List labels = treeNode.getChildren().stream().map(TreeNode::getLabel).collect(Collectors.toList());
            RowOperationUtil.writeMeta(this.createRow(this.sheet, this.rowNum++), "", labels);
            Name name = this.sheet.getWorkbook().createName();
            name.setNameName(nameName);
            String formula = StringUtil.format((String)"{}!${}${}:${}${}", (Object[])new Object[]{this.sheet.getSheetName(), "B", this.rowNum - 1, CellOperateUtil.toColumnLabel(treeNode.getChildren().size() + 1), this.rowNum - 1});
            name.setRefersToFormula(formula);
            for (TreeNode child : treeNode.getChildren()) {
                this.writeTreeMeta(child);
            }
        }
    }

    private void saveHeaders(Headers headers) {
        RowOperationUtil.writeData(this.createRow(this.sheet, this.rowNum++), CollectionUtil.list((Object[])new String[]{"__HEADER__START", headers.getName()}));
        if (CollectionUtil.isNotEmpty(headers.getDataHeaders())) {
            headers.getDataHeaders().forEach(s -> {
                DVConstraintType dvConstraintType = s.getDVConstraintType();
                String metaName = s.getMeta() != null ? s.getMeta().getName() : "";
                String referHeaderIndex = s.getReferHeader() != null ? Integer.toString(s.getReferHeader().getStartColumnNum()) : "";
                RowOperationUtil.writeData(this.createRow(this.sheet, this.rowNum++), CollectionUtil.list((Object[])new Serializable[]{s.getKey(), s.getValue(), Integer.valueOf(s.getStartColumnNum()), dvConstraintType, metaName, referHeaderIndex}));
            });
        }
        RowOperationUtil.writeData(this.createRow(this.sheet, this.rowNum++), CollectionUtil.list((Object[])new String[]{"__END__"}));
    }

    protected Row createRow(Sheet sheet, int rowNum) {
        return sheet.createRow(rowNum - 1);
    }

    protected String encodeNameName(String str) {
        if (StringUtil.isEmpty((CharSequence)str)) {
            throw new IllegalArgumentException("excel name's name is not empty");
        }
        String name = String.valueOf('_').concat(str);
        return StringUtil.replace((CharSequence)name, (CharSequence)" ", (CharSequence)"");
    }
}

