/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import jexx.base.Tuple2;
import jexx.convert.Convert;
import jexx.log.Log;
import jexx.log.LogFactory;
import jexx.poi.exception.POIException;
import jexx.poi.header.ArrayDataHeader;
import jexx.poi.header.DefaultDataHeader;
import jexx.poi.header.Headers;
import jexx.poi.header.IDataHeader;
import jexx.poi.header.TreeDataHeader;
import jexx.poi.meta.AbstractMetaSheet;
import jexx.poi.meta.ArrayMeta;
import jexx.poi.meta.DVConstraintType;
import jexx.poi.meta.IMeta;
import jexx.poi.meta.IMetaReader;
import jexx.poi.meta.Metas;
import jexx.poi.meta.TreeMeta;
import jexx.poi.meta.node.INode;
import jexx.poi.meta.node.Node;
import jexx.poi.meta.node.TreeNode;
import jexx.poi.util.CellOperateUtil;
import jexx.poi.util.RowOperationUtil;
import jexx.util.Assert;
import jexx.util.CollectionUtil;
import jexx.util.StringUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class MetaSheetReader
extends AbstractMetaSheet
implements IMetaReader {
    private static final Log LOG = LogFactory.get();
    private int rowIndex;
    protected Metas excelMeta;

    public MetaSheetReader(Sheet sheet) {
        this.sheet = sheet;
    }

    public Metas readMeta() {
        Row row;
        String cellValue;
        int rowNum = this.sheet.getLastRowNum();
        this.excelMeta = new Metas();
        while (this.rowIndex <= rowNum && !StringUtil.isEmpty((CharSequence)(cellValue = CellOperateUtil.getStringCellValue((row = this.sheet.getRow(this.rowIndex++)).getCell(0))))) {
            if ("__METADATA__START".equals(cellValue)) {
                String metaType = CellOperateUtil.getStringCellValue(row.getCell(1));
                DVConstraintType constraintType = DVConstraintType.valueOf(metaType);
                if (DVConstraintType.ARRAY == constraintType) {
                    ArrayMeta arrayMeta = this.readArrayMeta();
                    this.excelMeta.addMeta(arrayMeta);
                    continue;
                }
                if (DVConstraintType.TREE == constraintType) {
                    TreeMeta treeMeta = this.readTreeMeta();
                    this.excelMeta.addMeta(treeMeta);
                    continue;
                }
                throw new IllegalArgumentException(StringUtil.format((String)"constraintType[{}] can't handle", (Object[])new Object[]{metaType}));
            }
            if (!"__HEADER__START".equals(cellValue)) continue;
            String headerName = CellOperateUtil.getStringCellValue(row.getCell(1));
            Headers headers = this.readerHeaders(headerName);
            this.excelMeta.addHeaders(headers);
        }
        return this.excelMeta;
    }

    private Tuple2<String, List<INode>> readValue() {
        Object value;
        Row row = this.sheet.getRow(this.rowIndex++);
        Row nextRow = this.sheet.getRow(this.rowIndex++);
        String name = CellOperateUtil.getStringCellValue(row.getCell(0));
        int lastCellNum = row.getLastCellNum();
        ArrayList<Node> values = new ArrayList<Node>();
        for (int i = 1; i <= lastCellNum && (value = CellOperateUtil.getCellValue(row.getCell(i))) != null; ++i) {
            Object label = CellOperateUtil.getCellValue(nextRow.getCell(i));
            Node node = new Node(value, label);
            values.add(node);
        }
        name = this.decodeNameName(name);
        return new Tuple2((Object)name, values);
    }

    protected String decodeNameName(String str) {
        if (StringUtil.isEmpty((CharSequence)str) || str.charAt(0) != '_') {
            throw new IllegalArgumentException(StringUtil.format((String)"excel name's name[{}] is not illegal", (Object[])new Object[]{str}));
        }
        return str.substring(1);
    }

    private ArrayMeta readArrayMeta() {
        Tuple2<String, List<INode>> tuple2 = this.readValue();
        Row nextRow = this.sheet.getRow(this.rowIndex++);
        String endTag = CellOperateUtil.getStringCellValue(nextRow.getCell(0));
        Assert.isTrue((boolean)"__END__".equals(endTag), (String)"ArrayMeta must has end tag!", (Object[])new Object[0]);
        return new ArrayMeta((String)tuple2.getFirst(), (List)tuple2.getSecond());
    }

    private TreeMeta readTreeMeta() {
        Row row;
        HashMap<String, TreeNode> treeMap = new HashMap<String, TreeNode>();
        TreeNode rootTree = null;
        while ((row = this.sheet.getRow(this.rowIndex)) != null) {
            String endTag = CellOperateUtil.getStringCellValue(row.getCell(0));
            if ("__END__".equals(endTag)) {
                ++this.rowIndex;
                break;
            }
            Tuple2<String, List<INode>> tuple2 = this.readValue();
            String treeName = (String)tuple2.getFirst();
            int lastIndex = treeName.lastIndexOf("_");
            String name = treeName.substring(lastIndex + 1);
            TreeNode tree = (TreeNode)treeMap.get(treeName);
            if (tree == null) {
                tree = new TreeNode(name);
                if (rootTree == null) {
                    tree.setRoot(true);
                    rootTree = tree;
                }
                treeMap.put(treeName, tree);
            }
            if (!CollectionUtil.isNotEmpty((Collection)((Collection)tuple2.getSecond()))) continue;
            List<TreeNode> children = tree.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>();
                tree.setChildren(children);
            }
            for (INode node : (List)tuple2.getSecond()) {
                TreeNode tNode = new TreeNode(node.getValue(), node.getLabel());
                tNode.setParent(tree);
                treeMap.putIfAbsent(tNode.getFullLabel(), tNode);
                children.add(tNode);
            }
        }
        if (rootTree == null) {
            throw new NullPointerException("Root tree not find!");
        }
        return new TreeMeta(rootTree.getFullLabel(), rootTree);
    }

    private Headers readerHeaders(String headerName) {
        Row row;
        Headers headers = new Headers(headerName);
        while ((row = this.sheet.getRow(this.rowIndex)) != null) {
            IMeta meta;
            String metaName;
            String endTag = CellOperateUtil.getStringCellValue(row.getCell(0));
            if ("__END__".equals(endTag)) {
                ++this.rowIndex;
                break;
            }
            ++this.rowIndex;
            List<Object> list = RowOperationUtil.readRow(row);
            Assert.notNull(list);
            Assert.isTrue((list.size() >= 4 ? 1 : 0) != 0);
            String key = list.get(0).toString();
            String value = list.get(1).toString();
            short columnIndex = Convert.toShort((Object)list.get(2));
            DVConstraintType dvConstraintType = DVConstraintType.valueOf(list.get(3).toString());
            if (DVConstraintType.DEFAULT == dvConstraintType) {
                DefaultDataHeader header = new DefaultDataHeader(key, value);
                header.setStartColumnNum(columnIndex);
                header.setEndColumnNum(columnIndex);
                headers.addHeader(header);
                continue;
            }
            if (DVConstraintType.ARRAY == dvConstraintType) {
                Assert.isTrue((list.size() >= 5 ? 1 : 0) != 0, (String)"headerName={},key={}", (Object[])new Object[]{headerName, key});
                metaName = list.get(4).toString();
                meta = this.excelMeta.getMeta(metaName);
                Assert.isInstanceOf(ArrayMeta.class, (Object)meta);
                ArrayMeta arrayMeta = (ArrayMeta)meta;
                ArrayDataHeader arrayHeader = new ArrayDataHeader(key, value, arrayMeta);
                arrayHeader.setStartColumnNum(columnIndex);
                arrayHeader.setEndColumnNum(columnIndex);
                headers.addHeader(arrayHeader);
                continue;
            }
            if (DVConstraintType.TREE == dvConstraintType) {
                Assert.isTrue((list.size() >= 6 ? 1 : 0) != 0, (String)"headerName={},key={}", (Object[])new Object[]{headerName, key});
                metaName = list.get(4).toString();
                meta = this.excelMeta.getMeta(metaName);
                Assert.isInstanceOf(TreeMeta.class, (Object)meta);
                TreeMeta treeMeta = (TreeMeta)meta;
                short referHeaderColumnNum = Convert.toShort((Object)list.get(5), (Short)-1);
                IDataHeader referHeader = headers.getDataHeaderByColumnNum(referHeaderColumnNum);
                TreeDataHeader treeHeader = new TreeDataHeader(key, value, treeMeta, referHeader);
                treeHeader.setStartColumnNum(columnIndex);
                treeHeader.setEndColumnNum(columnIndex);
                headers.addHeader(treeHeader);
                continue;
            }
            throw new POIException("not right for header");
        }
        return headers;
    }
}

