/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.meta;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import jexx.poi.meta.IMeta;
import jexx.poi.meta.aspect.ExcelMeta;
import jexx.poi.meta.aspect.ExcelMetaLabel;
import jexx.poi.meta.aspect.ExcelMetaValue;
import jexx.poi.meta.node.INode;
import jexx.poi.meta.node.Node;
import jexx.util.Assert;
import jexx.util.CollectionUtil;
import jexx.util.ReflectUtil;

public class ArrayMeta
implements IMeta {
    private String name;
    private List<INode> valueMetas;
    private Map<Object, INode> valueMap;
    private Map<Object, INode> labelMap;

    public ArrayMeta(String name, List<INode> valueMetas) {
        this.name = name;
        this.valueMetas = valueMetas;
        this.valueMap = new HashMap<Object, INode>();
        this.labelMap = new HashMap<Object, INode>();
        for (INode valueMeta : valueMetas) {
            this.valueMap.put(valueMeta.getValue(), valueMeta);
            this.labelMap.put(valueMeta.getLabel(), valueMeta);
        }
    }

    public static <T> ArrayMeta buildMetaWithAnnotation(String name, List<T> list) {
        ArrayList<INode> valueMetas = new ArrayList<INode>();
        for (T t : list) {
            Object label;
            ExcelMeta excelMeta = (ExcelMeta)ReflectUtil.getAnnotationOfClass(t.getClass(), ExcelMeta.class);
            Assert.notNull((Object)excelMeta, (String)"Object don't contain the annotation ExcelMeta", (Object[])new Object[0]);
            List valueFields = ReflectUtil.getFieldsByAnnotation(t.getClass(), ExcelMetaValue.class);
            Assert.isTrue((valueFields.size() == 1 ? 1 : 0) != 0, (String)"Object has zero or more than one value field!", (Object[])new Object[0]);
            Field valueField = (Field)valueFields.get(0);
            Object value = ReflectUtil.getFieldValue(t, (Field)valueField);
            List labelFields = ReflectUtil.getFieldsByAnnotation(t.getClass(), ExcelMetaLabel.class);
            if (CollectionUtil.isNotEmpty((Collection)labelFields)) {
                Field labelField = (Field)labelFields.get(0);
                label = ReflectUtil.getFieldValue(t, (Field)labelField);
            } else {
                label = value;
            }
            valueMetas.add(new Node(value, label));
        }
        return new ArrayMeta(name, valueMetas);
    }

    public static <T, K, U> ArrayMeta buildMeta(String name, List<T> list, Function<? super T, ? extends K> valueMapper, Function<? super T, ? extends U> labelMapper) {
        Objects.requireNonNull(valueMapper);
        ArrayList<INode> nodes = new ArrayList<INode>();
        for (T t : list) {
            if (labelMapper != null) {
                nodes.add(new Node(valueMapper.apply(t), labelMapper.apply(t)));
                continue;
            }
            nodes.add(new Node(valueMapper.apply(t)));
        }
        return new ArrayMeta(name, nodes);
    }

    public static <T, K> ArrayMeta buildMeta(String name, List<T> list, Function<? super T, ? extends K> valueMapper) {
        return ArrayMeta.buildMeta(name, list, valueMapper, null);
    }

    public static <K, V> ArrayMeta buildMeta(String name, Map<K, V> map) {
        ArrayList<INode> nodes = new ArrayList<INode>();
        map.forEach((k, v) -> nodes.add(new Node(k, v)));
        return new ArrayMeta(name, nodes);
    }

    public static <T> ArrayMeta buildMeta(String name, List<T> list) {
        ArrayList<INode> nodes = new ArrayList<INode>();
        list.forEach(k -> nodes.add(new Node(k)));
        return new ArrayMeta(name, nodes);
    }

    public static <T> ArrayMeta buildMeta(String name, Set<T> list) {
        ArrayList<INode> nodes = new ArrayList<INode>();
        list.forEach(k -> nodes.add(new Node(k)));
        return new ArrayMeta(name, nodes);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public INode getNodeByFullValue(Object fullValue) {
        return this.valueMap.get(fullValue);
    }

    @Override
    public INode getNodeByFullLabel(Object fullLabel) {
        return this.labelMap.get(fullLabel);
    }

    public List<INode> getValueMetas() {
        return this.valueMetas;
    }
}

