/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.header.factory;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import jexx.poi.header.AbstractDataHeader;
import jexx.poi.header.ArrayDataHeader;
import jexx.poi.header.DefaultDataHeader;
import jexx.poi.header.Headers;
import jexx.poi.header.HeadersFactory;
import jexx.poi.header.ICustomHeader;
import jexx.poi.header.IDataHeader;
import jexx.poi.header.TreeDataHeader;
import jexx.poi.header.annotation.HeaderCollection;
import jexx.poi.header.annotation.HeaderColumn;
import jexx.poi.header.annotation.HeaderIgnore;
import jexx.poi.header.annotation.HeaderTable;
import jexx.poi.header.factory.HeaderColumnSelectMode;
import jexx.poi.header.factory.HeaderField;
import jexx.poi.meta.ArrayMeta;
import jexx.poi.meta.IMeta;
import jexx.poi.meta.Metas;
import jexx.poi.meta.TreeMeta;
import jexx.poi.style.CellStyleSets;
import jexx.poi.style.IWrapCellStyle;
import jexx.util.ArrayUtil;
import jexx.util.Assert;
import jexx.util.ClassUtil;
import jexx.util.CollectionUtil;
import jexx.util.ReflectUtil;
import jexx.util.StringUtil;

public class HeadersFactoryImpl
implements HeadersFactory {
    private HeaderColumnSelectMode selectMode = HeaderColumnSelectMode.ALL;
    private Class[] groups;
    private Map<String, IWrapCellStyle> cellStyleMap;
    private IWrapCellStyle defaultHeaderCellStyle = CellStyleSets.HEADER_CELL_STYLE;
    private IWrapCellStyle defaultDataCellStyle = CellStyleSets.DATA_CELL_STYLE;
    private Metas metas;
    private List<String> ignoreFields;
    private Map<String, String> i18nMap;
    private ResourceBundle resourceBundle;
    private List<IDataHeader> replaceHeaders = new ArrayList<IDataHeader>();
    private List<Operation> operations = new ArrayList<Operation>();

    @Override
    public HeadersFactory withCellStyle(String name, IWrapCellStyle cellStyle) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((CharSequence)name), (String)"name is not empty!", (Object[])new Object[0]);
        if (this.cellStyleMap == null) {
            this.cellStyleMap = new HashMap<String, IWrapCellStyle>();
        }
        this.cellStyleMap.put(name, cellStyle);
        return this;
    }

    @Override
    public HeadersFactory withDefaultHeaderCellStyle(IWrapCellStyle cellStyle) {
        this.defaultHeaderCellStyle = cellStyle;
        return this;
    }

    @Override
    public HeadersFactory withDefaultDataCellStyle(IWrapCellStyle cellStyle) {
        this.defaultDataCellStyle = cellStyle;
        return this;
    }

    @Override
    public HeadersFactory withMetas(Metas metas) {
        this.metas = metas;
        return this;
    }

    @Override
    public HeadersFactory select(HeaderColumnSelectMode mode) {
        this.selectMode = mode;
        return this;
    }

    @Override
    public HeadersFactory group(Class ... groups) {
        this.groups = groups;
        return this;
    }

    @Override
    public HeadersFactory ignoreField(String ... fields) {
        if (this.ignoreFields == null) {
            this.ignoreFields = new ArrayList<String>();
        }
        Collections.addAll(this.ignoreFields, fields);
        return this;
    }

    @Override
    public HeadersFactory i18n(Map<String, String> i18nMap) {
        this.i18nMap = i18nMap;
        return this;
    }

    @Override
    public HeadersFactory i18n(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        return this;
    }

    protected String convertValue(String value) {
        if (value == null) {
            return null;
        }
        String newValue = value;
        if (this.i18nMap != null) {
            newValue = this.i18nMap.get(newValue);
        }
        if (newValue == null && this.resourceBundle != null) {
            newValue = this.resourceBundle.getString(value);
        }
        return newValue == null ? value : newValue;
    }

    @Override
    public HeadersFactory replace(IDataHeader header) {
        this.replaceHeaders.add(header);
        return this;
    }

    @Override
    public HeadersFactory addHeaderAfter(String headerName, ICustomHeader header) {
        Operation operation = new Operation();
        operation.headerName = headerName;
        operation.type = 2;
        operation.header = header;
        this.operations.add(operation);
        return this;
    }

    @Override
    public HeadersFactory addHeaderBefore(String headerName, ICustomHeader header) {
        Operation operation = new Operation();
        operation.headerName = headerName;
        operation.type = 1;
        operation.header = header;
        this.operations.add(operation);
        return this;
    }

    @Override
    public Headers build(Class<?> clazz) {
        String name;
        if (HeaderColumnSelectMode.ALL == this.selectMode) {
            name = "default";
        } else {
            HeaderTable table = (HeaderTable)ReflectUtil.getAnnotationOfClass(clazz, HeaderTable.class);
            Assert.notNull((Object)table, (String)"Class[{}] no support to build header", (Object[])new Object[]{clazz});
            name = table.name();
        }
        List<HeaderField> headerFields = new ArrayList<HeaderField>();
        this.doScanCollection("", clazz, headerFields);
        HashMap<String, IDataHeader> headerMap = new HashMap<String, IDataHeader>();
        this.doRecursionHeader(new ArrayList<HeaderField>(headerFields), headerMap);
        if (CollectionUtil.isNotEmpty(this.replaceHeaders)) {
            this.replaceHeaders.forEach(s -> {
                if (headerMap.get(s.getKey()) != null) {
                    headerMap.put(s.getKey(), (IDataHeader)s);
                }
            });
        }
        headerFields = headerFields.stream().sorted(Comparator.comparingInt(HeaderField::getOrder)).collect(Collectors.toList());
        Map<String, List<Operation>> operationGroupMap = this.operations.stream().collect(Collectors.groupingBy(s -> s.headerName));
        Headers headers = new Headers(name);
        headers.setDefaultHeaderCellStyle(this.defaultHeaderCellStyle);
        headers.setDefaultDataCellStyle(this.defaultDataCellStyle);
        for (HeaderField field : headerFields) {
            IDataHeader dataHeader = (IDataHeader)headerMap.get(field.getFieldName());
            Assert.notNull((Object)dataHeader);
            List<Operation> operations = operationGroupMap.remove(field.getFieldName());
            if (CollectionUtil.isEmpty(operations)) {
                headers.addHeader(dataHeader);
                continue;
            }
            for (Operation operation : operations) {
                if (1 != operation.type) continue;
                headers.addHeader(operation.header);
            }
            headers.addHeader(dataHeader);
            for (Operation operation : operations) {
                if (2 != operation.type) continue;
                headers.addHeader(operation.header);
            }
        }
        Assert.isEmpty(operationGroupMap, (String)"can't handle this custom header, {}", (Object[])new Object[]{operationGroupMap.keySet()});
        headers.flush();
        return headers;
    }

    private void doScanCollection(String prefix, Class<?> clazz, List<HeaderField> headerFields) {
        Object[] fields = ReflectUtil.getFields(clazz);
        Assert.notEmpty((Object[])fields, (String)"Class {} has no field to build headers!", (Object[])new Object[]{clazz});
        for (Object field : fields) {
            HeaderField headerField;
            String fieldName = prefix.concat(((Field)field).getName());
            if (this.ignoreFields != null && this.ignoreFields.indexOf(fieldName) > -1) continue;
            HeaderIgnore headerIgnore = ((Field)field).getAnnotation(HeaderIgnore.class);
            HeaderColumn headerColumn = ((Field)field).getAnnotation(HeaderColumn.class);
            HeaderCollection headerCollection = ((Field)field).getAnnotation(HeaderCollection.class);
            Assert.isTrue((headerColumn == null || headerCollection == null ? 1 : 0) != 0, (String)"A field can't  support HeaderColumn and HeaderCollection at same time", (Object[])new Object[0]);
            if (HeaderColumnSelectMode.ALL == this.selectMode) {
                headerField = new HeaderField();
                headerField.setFieldName(fieldName);
                headerField.setValue(fieldName);
                headerFields.add(headerField);
                continue;
            }
            if (HeaderColumnSelectMode.ALL_WITH_TAG != this.selectMode && HeaderColumnSelectMode.ONLY_TAG != this.selectMode || headerIgnore != null) continue;
            if (headerCollection != null) {
                Assert.isTrue((((Field)field).getType().isArray() || List.class == ((Field)field).getType() || Set.class == ((Field)field).getType() ? 1 : 0) != 0, (String)"field [{}] is not array or collection", (Object[])new Object[]{fieldName});
                Class componentType = clazz.isArray() ? clazz.getComponentType() : ClassUtil.getComponentType((Type)((Field)field).getGenericType());
                Assert.notNull((Object)componentType, (String)"check field [{}] because HeaderCollection", (Object[])new Object[]{fieldName});
                this.doScanCollection(fieldName.concat("[]."), componentType, headerFields);
                continue;
            }
            if (headerColumn != null) {
                if (!this.checkGroup(headerColumn)) continue;
                headerField = new HeaderField();
                headerField.setFieldName(headerColumn.list() ? fieldName.concat("[]") : fieldName);
                headerField.setValue(headerColumn.value());
                headerField.setOrder(headerColumn.order());
                headerField.setHeaderCellStyle(headerColumn.headerCellStyle());
                headerField.setDataCellStyle(headerColumn.dataCellStyle());
                headerField.setReferKey(headerColumn.referKey());
                headerField.setMeta(headerColumn.meta());
                headerField.setValid(headerColumn.valid());
                headerFields.add(headerField);
                continue;
            }
            if (HeaderColumnSelectMode.ALL_WITH_TAG != this.selectMode) continue;
            headerField = new HeaderField();
            headerField.setFieldName(fieldName);
            headerField.setValue(fieldName);
            headerFields.add(headerField);
        }
        Assert.notEmpty(headerFields, (String)"No field to build headers!", (Object[])new Object[0]);
    }

    private void doRecursionHeader(List<HeaderField> headerFields, Map<String, IDataHeader> dataHeaderMap) {
        int size = headerFields.size();
        Iterator<HeaderField> headerFieldIterator = headerFields.iterator();
        while (headerFieldIterator.hasNext()) {
            AbstractDataHeader header;
            HeaderField headerField = headerFieldIterator.next();
            String referKey = headerField.getReferKey();
            IDataHeader referHeader = null;
            if (StringUtil.isNotEmpty((CharSequence)referKey) && (referHeader = dataHeaderMap.get(referKey)) == null) continue;
            IWrapCellStyle headerCellStyle = this.defaultHeaderCellStyle;
            IWrapCellStyle dataCellStyle = this.defaultDataCellStyle;
            if (this.cellStyleMap != null) {
                if (!"".equals(headerField.getHeaderCellStyle())) {
                    headerCellStyle = this.cellStyleMap.get(headerField.getHeaderCellStyle());
                }
                if (!"".equals(headerField.getDataCellStyle())) {
                    dataCellStyle = this.cellStyleMap.get(headerField.getDataCellStyle());
                }
            }
            IMeta meta = null;
            if (this.metas != null && StringUtil.isNotEmpty((CharSequence)headerField.getMeta())) {
                meta = this.metas.getMeta(headerField.getMeta());
            }
            String value = this.convertValue(headerField.getValue());
            if (meta == null) {
                header = new DefaultDataHeader(headerField.getFieldName(), value);
            } else if (meta instanceof ArrayMeta) {
                header = new ArrayDataHeader(headerField.getFieldName(), value, (ArrayMeta)meta);
            } else if (meta instanceof TreeMeta) {
                header = new TreeDataHeader(headerField.getFieldName(), value, (TreeMeta)meta, referHeader);
            } else {
                throw new UnsupportedOperationException(StringUtil.format((String)"cannot handle this meta \"{}\"", (Object[])new Object[]{meta}));
            }
            header.setValid(headerField.isValid());
            header.setHeaderCellStyle(headerCellStyle);
            header.setDataCellStyle(dataCellStyle);
            dataHeaderMap.put(headerField.getFieldName(), header);
            headerFieldIterator.remove();
        }
        if (headerFields.size() == size) {
            String referKeys = StringUtil.join(headerFields, (String)",", HeaderField::getReferKey);
            throw new IllegalArgumentException(StringUtil.format((String)"Please check the header column's referKey, referKeys=[{}] ", (Object[])new Object[]{referKeys}));
        }
        if (headerFields.size() > 0) {
            this.doRecursionHeader(headerFields, dataHeaderMap);
        }
    }

    private boolean checkGroup(HeaderColumn headerColumn) {
        if (headerColumn == null || ArrayUtil.isEmpty((Object[])headerColumn.group()) || ArrayUtil.isEmpty((Object[])this.groups)) {
            return true;
        }
        for (Class c : headerColumn.group()) {
            for (Class b : this.groups) {
                if (c != b) continue;
                return true;
            }
        }
        return false;
    }

    private static class Operation {
        public static final int BEFORE = 1;
        public static final int AFTER = 2;
        public String headerName;
        public int type;
        public ICustomHeader header;

        private Operation() {
        }
    }
}

