/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.header;

import java.util.ArrayList;
import java.util.Map;
import jexx.poi.header.AbstractDataHeader;
import jexx.poi.header.IDataHeader;
import jexx.poi.meta.DVConstraintType;
import jexx.poi.meta.TreeMeta;
import jexx.poi.meta.node.INode;

public class TreeDataHeader
extends AbstractDataHeader {
    private TreeMeta meta;
    private IDataHeader referHeader;

    public TreeDataHeader(String key, String value, int columnCount, TreeMeta meta, IDataHeader referHeader) {
        super(key, value, columnCount);
        this.meta = meta;
        this.referHeader = referHeader;
    }

    public TreeDataHeader(String key, String value, TreeMeta meta, IDataHeader referHeader) {
        this(key, value, 1, meta, referHeader);
    }

    @Override
    public DVConstraintType getDVConstraintType() {
        return DVConstraintType.TREE;
    }

    @Override
    public IDataHeader getReferHeader() {
        return this.referHeader;
    }

    @Override
    public TreeMeta getMeta() {
        return this.meta;
    }

    @Override
    public INode getNodeByLabel(Map<String, Object> labelMap) {
        String fullLabel = this.getLabelOrValue(labelMap);
        return this.meta.getNodeByFullLabel(fullLabel);
    }

    private String getLabelOrValue(Map<?, ?> data) {
        Object lv = data.get(this.key);
        ArrayList lvs = new ArrayList();
        lvs.add(lv);
        for (IDataHeader next = this.referHeader; next != null; next = next.getReferHeader()) {
            lvs.add(data.get(next.getKey()));
        }
        int length = lvs.size();
        StringBuilder sb = new StringBuilder(this.meta.getName());
        for (int i = length - 1; i >= 0; --i) {
            sb.append("_").append(lvs.get(i));
        }
        return sb.toString();
    }
}

