/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.header;

import java.util.Objects;
import jexx.poi.cell.FormulaCellValue;
import jexx.poi.header.AbstractCustomHeader;
import jexx.poi.header.ICustomHeader;
import jexx.poi.header.IDataHeader;
import jexx.poi.row.DataRow;
import jexx.poi.style.CellStyleSets;
import jexx.poi.style.IWrapCellStyle;

public class FormulaDataHeader
extends AbstractCustomHeader
implements ICustomHeader {
    private FormulaFunction function;

    public FormulaDataHeader(String value, int columnCount, IDataHeader sameLevelHeader, FormulaFunction function, IWrapCellStyle headerCellStyle, IWrapCellStyle dataCellStyle) {
        super(value, columnCount, sameLevelHeader);
        Objects.requireNonNull(function);
        this.function = function;
        this.setHeaderCellStyle(headerCellStyle);
        this.setDataCellStyle(dataCellStyle);
    }

    public FormulaDataHeader(String value, int columnCount, IDataHeader sameLevelHeader, FormulaFunction function) {
        this(value, columnCount, sameLevelHeader, function, CellStyleSets.HEADER_CELL_STYLE, CellStyleSets.DATA_CELL_STYLE);
    }

    public FormulaDataHeader(String value, int columnCount, String sameLevelHeaderName, FormulaFunction function, IWrapCellStyle headerCellStyle, IWrapCellStyle dataCellStyle) {
        super(value, columnCount, sameLevelHeaderName, headerCellStyle, dataCellStyle);
        Objects.requireNonNull(function);
        this.function = function;
    }

    public FormulaDataHeader(String value, int columnCount, String sameLevelHeaderName, FormulaFunction function) {
        this(value, columnCount, sameLevelHeaderName, function, CellStyleSets.HEADER_CELL_STYLE, CellStyleSets.DATA_CELL_STYLE);
    }

    public FormulaDataHeader(String value, String sameLevelHeaderName, FormulaFunction function, IWrapCellStyle headerCellStyle, IWrapCellStyle dataCellStyle) {
        this(value, 1, sameLevelHeaderName, function, headerCellStyle, dataCellStyle);
    }

    public FormulaDataHeader(String value, String sameLevelHeaderName, FormulaFunction function) {
        this(value, 1, sameLevelHeaderName, function, CellStyleSets.HEADER_CELL_STYLE, CellStyleSets.DATA_CELL_STYLE);
    }

    public FormulaDataHeader(String value, int columnCount, FormulaFunction function, IWrapCellStyle headerCellStyle, IWrapCellStyle dataCellStyle) {
        this(value, columnCount, (String)null, function, headerCellStyle, dataCellStyle);
    }

    public FormulaDataHeader(String value, FormulaFunction function, IWrapCellStyle headerCellStyle, IWrapCellStyle dataCellStyle) {
        this(value, 1, function, headerCellStyle, dataCellStyle);
    }

    public FormulaDataHeader(String value, FormulaFunction function) {
        this(value, 1, function, CellStyleSets.HEADER_CELL_STYLE, CellStyleSets.DATA_CELL_STYLE);
    }

    @Override
    public Object getCustomValue(DataRow row, int itemIndex) {
        String formula = this.function.formula(row, itemIndex, this.getStartColumnNum());
        return new FormulaCellValue(formula);
    }

    public static interface FormulaFunction {
        public String formula(DataRow var1, int var2, int var3);
    }
}

