/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.header;

import java.util.Map;
import jexx.log.Log;
import jexx.log.LogFactory;
import jexx.poi.header.AbstractDataHeader;
import jexx.poi.header.IDataHeader;
import jexx.poi.meta.ArrayMeta;
import jexx.poi.meta.DVConstraintType;
import jexx.poi.meta.node.INode;
import jexx.poi.meta.node.NullNode;

public class ArrayDataHeader
extends AbstractDataHeader {
    private static final Log LOG = LogFactory.get();
    private ArrayMeta meta;

    public ArrayDataHeader(String key, String value, int columnCount, ArrayMeta meta) {
        super(key, value, columnCount);
        this.meta = meta;
    }

    public ArrayDataHeader(String key, String value, ArrayMeta meta) {
        this(key, value, 1, meta);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public DVConstraintType getDVConstraintType() {
        return DVConstraintType.ARRAY;
    }

    @Override
    public ArrayMeta getMeta() {
        return this.meta;
    }

    @Override
    public IDataHeader getReferHeader() {
        return null;
    }

    @Override
    public INode getNodeByLabel(Map<String, Object> labelMap) {
        Object label = labelMap.get(this.key);
        if (label == null) {
            return NullNode.instance();
        }
        return this.meta.getNodeByFullLabel(label.toString());
    }
}

