/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.header;

import java.util.Objects;
import jexx.poi.header.AbstractHeader;
import jexx.poi.header.IDataHeader;
import jexx.poi.header.label.LabelFunction;
import jexx.poi.header.label.LabelUnwrapFunction;
import jexx.poi.header.label.LabelWrapFunction;
import jexx.poi.style.CellStyleSets;
import jexx.poi.style.IWrapCellStyle;

public abstract class AbstractDataHeader<T extends AbstractDataHeader>
extends AbstractHeader
implements IDataHeader {
    protected boolean valid = true;
    protected LabelWrapFunction labelWrapFunction;
    protected LabelUnwrapFunction labelUnwrapFunction;
    private IWrapCellStyle dataCellStyle;

    public AbstractDataHeader(String key, String value, int columnCount) {
        Objects.requireNonNull(key);
        this.key = key;
        this.value = value;
        this.columnCount = columnCount;
        this.headerCellStyle = CellStyleSets.HEADER_CELL_STYLE;
        this.dataCellStyle = CellStyleSets.DATA_CELL_STYLE;
    }

    public AbstractDataHeader(String key, String value) {
        this(key, value, 1);
    }

    private T _this() {
        return (T)this;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public T label(LabelFunction labelFunction) {
        this.wrapLabel(labelFunction);
        this.unwrapLabel(labelFunction);
        return this._this();
    }

    public T wrapLabel(LabelWrapFunction labelWrapFunction) {
        this.labelWrapFunction = labelWrapFunction;
        return this._this();
    }

    public T unwrapLabel(LabelUnwrapFunction labelUnwrapFunction) {
        this.labelUnwrapFunction = labelUnwrapFunction;
        return this._this();
    }

    public T setDataCellStyle(IWrapCellStyle dataCellStyle) {
        this.dataCellStyle = dataCellStyle;
        return this._this();
    }

    @Override
    public LabelWrapFunction getWrapLabelFunction() {
        return this.labelWrapFunction;
    }

    @Override
    public LabelUnwrapFunction getUnwrapLabelFunction() {
        return this.labelUnwrapFunction;
    }

    @Override
    public IWrapCellStyle getDataCellStyle() {
        return this.dataCellStyle;
    }
}

