/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.cell;

import java.util.Stack;
import jexx.poi.cell.ICell;
import jexx.poi.meta.ArrayMeta;
import jexx.poi.meta.IMeta;
import jexx.poi.meta.TreeMeta;
import jexx.util.Assert;
import jexx.util.StringUtil;

public interface ICellSupportMeta
extends ICell {
    public static final char NAME_PREFIX = '_';

    public boolean supportMeta();

    public IMeta getMeta();

    public boolean isValid();

    public ICellSupportMeta getCellReference();

    public void setCellReference(ICellSupportMeta var1);

    default public Object getFullValue() {
        if (this.supportMeta()) {
            IMeta meta = this.getMeta();
            if (meta instanceof ArrayMeta) {
                return this.getValue();
            }
            Stack<ICellSupportMeta> stack = new Stack<ICellSupportMeta>();
            for (ICellSupportMeta refer = this; refer != null; refer = refer.getCellReference()) {
                stack.push(refer);
            }
            StringBuilder nameBuilder = new StringBuilder(meta.getName());
            if (!stack.isEmpty()) {
                ICell fetch = (ICell)stack.pop();
                while (fetch != null) {
                    nameBuilder.append("_").append(fetch.getValue());
                    if (stack.isEmpty()) break;
                    fetch = (ICell)stack.pop();
                }
            }
            return nameBuilder.toString();
        }
        return this.getValue();
    }

    default public String createNameName() {
        IMeta meta = this.getMeta();
        Assert.notNull((Object)meta, (String)"Cell's meta cannot be null!", (Object[])new Object[0]);
        StringBuilder nameBuilder = new StringBuilder("INDIRECT(SUBSTITUTE(CONCATENATE(");
        nameBuilder.append("\"").append('_').append("\",");
        nameBuilder.append(",\"").append(meta.getName()).append("\"");
        if (!(meta instanceof ArrayMeta)) {
            if (meta instanceof TreeMeta) {
                Stack<ICellSupportMeta> stack = new Stack<ICellSupportMeta>();
                for (ICellSupportMeta refer = this.getCellReference(); refer != null; refer = refer.getCellReference()) {
                    stack.push(refer);
                }
                if (!stack.isEmpty()) {
                    ICell fetch = (ICell)stack.pop();
                    while (fetch != null) {
                        nameBuilder.append(",\"").append("_").append("\",");
                        nameBuilder.append("$").append(fetch.getFirstColumnNo()).append(fetch.getFirstRowNum());
                        if (!stack.isEmpty()) {
                            fetch = (ICell)stack.pop();
                            continue;
                        }
                        break;
                    }
                }
            } else {
                throw new IllegalArgumentException(StringUtil.format((String)"cannot handle this meta, meta[{}]!", (Object[])new Object[]{meta.getClass()}));
            }
        }
        nameBuilder.append("),\" \",\"\"))");
        return nameBuilder.toString();
    }
}

