/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.cell;

import jexx.poi.cell.IMergedCell;
import jexx.poi.cell.IRowCell;
import jexx.poi.header.label.LabelWrapFunction;
import jexx.poi.row.Row;
import jexx.poi.style.IWrapCellStyle;
import jexx.poi.util.CellOperateUtil;
import jexx.random.RandomUtil;
import jexx.util.Assert;

public abstract class AbstractCell
implements IMergedCell,
IRowCell {
    protected String id;
    protected int firstRowNum;
    protected int firstColumnNum;
    protected int lastRowNum;
    protected int lastColumnNum;
    protected Object value;
    protected IWrapCellStyle cellStyle;
    protected Row row;
    protected LabelWrapFunction labelWrapFunction;

    public AbstractCell(int firstRowNum, int firstColumnNum, int lastRowNum, int lastColumnNum, Object value, IWrapCellStyle cellStyle) {
        Assert.isTrue((firstRowNum <= lastRowNum && firstColumnNum <= lastColumnNum ? 1 : 0) != 0, (String)"firstRowNum={}, firstColumnNum={},lastRowNum={},lastColumnNum={}", (Object[])new Object[]{firstRowNum, firstColumnNum, lastRowNum, lastColumnNum});
        this.id = RandomUtil.simpleUUID();
        this.firstRowNum = firstRowNum;
        this.firstColumnNum = firstColumnNum;
        this.lastRowNum = lastRowNum;
        this.lastColumnNum = lastColumnNum;
        this.value = value;
        this.cellStyle = cellStyle;
    }

    public AbstractCell(int firstRowNum, int firstColumnNum, Object value, IWrapCellStyle cellStyle) {
        this(firstRowNum, firstColumnNum, firstRowNum, firstColumnNum, value, cellStyle);
    }

    public AbstractCell(Row row, int firstColumnNum, int lastColumnNum, Object value, IWrapCellStyle cellStyle) {
        this(row.getStartRowNum(), firstColumnNum, row.getEndRowNum(), lastColumnNum, value, cellStyle);
        this.row = row;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getFirstRowNum() {
        return this.row != null ? this.row.getStartRowNum() : this.firstRowNum;
    }

    @Override
    public int getLastRowNum() {
        return this.row != null ? this.row.getEndRowNum() : this.lastRowNum;
    }

    @Override
    public int getFirstColumnNum() {
        return this.firstColumnNum;
    }

    @Override
    public int getLastColumnNum() {
        return this.lastColumnNum;
    }

    @Override
    public String getFirstColumnNo() {
        return CellOperateUtil.toColumnLabel(this.getFirstColumnNum());
    }

    @Override
    public String getLastColumnNo() {
        return CellOperateUtil.toColumnLabel(this.getLastColumnNum());
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public Object getLabel() {
        return this.labelWrapFunction != null ? this.labelWrapFunction.wrap(this.value) : this.value;
    }

    @Override
    public IWrapCellStyle getCellStyle() {
        return this.cellStyle;
    }

    public void setCellStyle(IWrapCellStyle cellStyle) {
        this.cellStyle = cellStyle;
    }

    public void setLabelWrapFunction(LabelWrapFunction labelWrapFunction) {
        this.labelWrapFunction = labelWrapFunction;
    }

    @Override
    public Row getRow() {
        return this.row;
    }
}

