/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import jexx.bean.BeanUtil;
import jexx.log.Log;
import jexx.log.LogFactory;
import jexx.poi.cell.IMergedCell;
import jexx.poi.header.Headers;
import jexx.poi.header.IHeader;
import jexx.poi.row.RowContext;
import jexx.poi.style.CellStyleMapper;
import jexx.poi.style.CellStyleSets;
import jexx.poi.writer.IndexRowWriter;
import jexx.poi.writer.MapRowWriter;
import jexx.poi.writer.SheetRowWriter;
import jexx.util.Assert;
import jexx.util.CollectionUtil;
import jexx.util.MapUtil;
import org.apache.poi.ss.usermodel.Sheet;

public class SheetWriter
extends SheetRowWriter {
    private static final Log LOG = LogFactory.get(SheetWriter.class);
    protected int currentRowNum = 0;
    private MapRowWriter mapRowWriter = new MapRowWriter();
    private IndexRowWriter indexRowWriter = new IndexRowWriter();

    public SheetWriter(Sheet sheet) {
        super(sheet);
    }

    public int getCurrentRowNum() {
        return this.currentRowNum;
    }

    public SheetWriter passCurrentRow() {
        this.skipRows(1);
        return this;
    }

    public SheetWriter skipRows(int skipRowNum) {
        this.currentRowNum += skipRowNum;
        return this;
    }

    public SheetWriter jumpToRowNum(int rowNum) {
        Assert.isTrue((rowNum > 0 ? 1 : 0) != 0, (String)"rowNum is not illegal", (Object[])new Object[0]);
        this.currentRowNum = rowNum;
        return this;
    }

    public SheetWriter writeHeader(int rowNum, Headers headers, CellStyleMapper cellStyleMapper) {
        this.currentRowNum = this.doWriteRow(rowNum, headers, cellStyleMapper);
        return this;
    }

    public SheetWriter writeHeader(Headers headers, CellStyleMapper cellStyleMapper) {
        return this.writeHeader(++this.currentRowNum, headers, cellStyleMapper);
    }

    public SheetWriter writeHeader(Headers headers) {
        return this.writeHeader(headers, null);
    }

    public SheetWriter writeHeaderWithDefaultStyle(int rowNum, Headers headers) {
        return this.writeHeader(rowNum, headers, cell -> CellStyleSets.HEADER_CELL_STYLE);
    }

    public SheetWriter writeHeaderWithDefaultStyle(Headers headers) {
        return this.writeHeader(headers, cell -> CellStyleSets.HEADER_CELL_STYLE);
    }

    public int writeRows(int startRowNum, int columnNum, List<?> rows, CellStyleMapper cellStyleMapper) {
        RowContext rowContext = null;
        for (Object row : rows) {
            if (row instanceof List) {
                rowContext = this.doWriteRow(startRowNum, columnNum, (List)row, cellStyleMapper);
                continue;
            }
            if (row instanceof Map) {
                Map map = (Map)row;
                rowContext = this.doWriteRow(startRowNum, columnNum, MapUtil.convertValueToList((Map)map), cellStyleMapper);
                continue;
            }
            rowContext = this.doWriteRow(startRowNum, columnNum, CollectionUtil.list((Object[])new String[]{row.toString()}), cellStyleMapper);
        }
        return rowContext == null ? -1 : rowContext.getEndRowNum();
    }

    public int writeRows(int columnNum, List<?> rows, CellStyleMapper cellStyleMapper) {
        return this.writeRows(this.currentRowNum + 1, columnNum, rows, cellStyleMapper);
    }

    public int writeRows(List<?> rows, CellStyleMapper cellStyleMapper) {
        return this.writeRows(1, rows, cellStyleMapper);
    }

    public int writeRowsWithDefaultStyle(int startRowNum, int columnNum, List<?> rows) {
        return this.writeRows(startRowNum, columnNum, rows, (IMergedCell cell) -> CellStyleSets.DATA_CELL_STYLE);
    }

    public int writeRowsWithDefaultStyle(int columnNum, List<?> rows) {
        return this.writeRowsWithDefaultStyle(this.currentRowNum + 1, columnNum, rows);
    }

    public int writeRowsWithDefaultStyle(List<?> rows) {
        return this.writeRowsWithDefaultStyle(1, rows);
    }

    public int writeRows(int startRowNum, List<?> rows, Headers headers, CellStyleMapper cellStyleMapper) {
        RowContext rowContext = null;
        for (int i = 0; i < rows.size(); ++i) {
            Object row = rows.get(i);
            int num = rowContext == null ? startRowNum : rowContext.getEndRowNum() + 1;
            rowContext = this.doWriteRow(num, row, headers, cellStyleMapper, i);
        }
        return rowContext == null ? -1 : rowContext.getEndRowNum();
    }

    public int writeRows(List<?> rows, Headers headers, CellStyleMapper cellStyleMapper) {
        return this.writeRows(this.currentRowNum + 1, rows, headers, cellStyleMapper);
    }

    public int writeRows(List<?> rows, Headers headers) {
        return this.writeRows(rows, headers, null);
    }

    public int writeRowsWithDefaultStyle(int startRowNum, List<?> rows, Headers headers) {
        return this.writeRows(startRowNum, rows, headers, (IMergedCell cell) -> CellStyleSets.DATA_CELL_STYLE);
    }

    public int writeRowsWithDefaultStyle(List<?> rows, Headers headers) {
        return this.writeRowsWithDefaultStyle(this.currentRowNum + 1, rows, headers);
    }

    public int writeMapRows(int startRowNum, List<Map<String, Object>> rows, Headers headers, CellStyleMapper cellStyleMapper) {
        RowContext rowContext = null;
        for (int i = 0; i < rows.size(); ++i) {
            Map<String, Object> row = rows.get(i);
            int num = rowContext == null ? startRowNum : rowContext.getEndRowNum() + 1;
            rowContext = this.doWriteRow(num, row, headers, cellStyleMapper, i);
        }
        return rowContext == null ? -1 : rowContext.getEndRowNum();
    }

    public int writeMapRows(List<Map<String, Object>> rows, Headers headers, CellStyleMapper cellStyleMapper) {
        return this.writeMapRows(this.currentRowNum + 1, rows, headers, cellStyleMapper);
    }

    public int writeMapRows(List<Map<String, Object>> rows, Headers headers) {
        return this.writeMapRows(rows, headers, null);
    }

    public int writeMapRowsWithDefaultStyle(int startRowNum, List<Map<String, Object>> rows, Headers headers) {
        return this.writeMapRows(startRowNum, rows, headers, cell -> CellStyleSets.DATA_CELL_STYLE);
    }

    public int writeMapRowsWithDefaultStyle(List<Map<String, Object>> rows, Headers headers) {
        return this.writeMapRowsWithDefaultStyle(this.currentRowNum + 1, rows, headers);
    }

    public SheetWriter fill(int fillStartRowNum, int fillEndRowNum, List<?> rows, Headers headers) {
        int fillLength = fillEndRowNum - fillStartRowNum + 1;
        Assert.isTrue((fillLength >= 0 ? 1 : 0) != 0);
        int rowsLength = rows.size();
        if (rowsLength > fillLength) {
            int specifyStyleRowNum = fillLength > 0 ? fillStartRowNum + 2 : fillStartRowNum;
            this.insertRows(specifyStyleRowNum, rowsLength - fillLength);
        }
        this.currentRowNum = fillStartRowNum - 1;
        this.writeRows(rows, headers);
        return this;
    }

    public RowContext writeRow(int startRowNum, Object rowData, Headers headers, CellStyleMapper cellStyleMapper) {
        Assert.notNull((Object)headers);
        RowContext rowContext = this.doWriteRow(startRowNum, rowData, headers, cellStyleMapper, 0);
        this.currentRowNum = rowContext.getEndRowNum();
        return rowContext;
    }

    public RowContext writeRow(Object rowData, Headers headers, CellStyleMapper cellStyleMapper) {
        return this.writeRow(this.currentRowNum + 1, rowData, headers, cellStyleMapper);
    }

    public RowContext writeRowWithDefaultStyle(int startRowNum, Object rowData, Headers headers) {
        return this.writeRow(startRowNum, rowData, headers, cell -> CellStyleSets.DATA_CELL_STYLE);
    }

    public RowContext writeRowWithDefaultStyle(Object rowData, Headers headers) {
        return this.writeRowWithDefaultStyle(this.currentRowNum + 1, rowData, headers);
    }

    public RowContext writeListRow(int rowNum, int columnNum, List<?> rowData, CellStyleMapper cellStyleMapper) {
        RowContext rowContext = this.doWriteRow(rowNum, columnNum, rowData, cellStyleMapper);
        this.currentRowNum = rowContext.getEndRowNum();
        return rowContext;
    }

    public RowContext writeListRow(int columnNum, List<?> rowData, CellStyleMapper cellStyleMapper) {
        return this.writeListRow(++this.currentRowNum, columnNum, rowData, cellStyleMapper);
    }

    public RowContext writeListRow(List<?> rowData, CellStyleMapper cellStyleMapper) {
        return this.writeListRow(1, rowData, cellStyleMapper);
    }

    public RowContext writeListRow(List<?> rowData) {
        return this.writeListRow(1, rowData, null);
    }

    public RowContext writeListRowWithDefaultStyle(int rowNum, int columnNum, List<?> rowData) {
        return this.writeListRow(rowNum, columnNum, rowData, cell -> CellStyleSets.DATA_CELL_STYLE);
    }

    public RowContext writeListRowWithDefaultStyle(int columnNum, List<?> rowData) {
        return this.writeListRowWithDefaultStyle(++this.currentRowNum, columnNum, rowData);
    }

    public RowContext writeListRowWithDefaultStyle(List<?> rowData) {
        return this.writeListRowWithDefaultStyle(1, rowData);
    }

    public RowContext writeMapRow(int rowNum, Map<String, Object> map, Headers headers, CellStyleMapper cellStyleMapper) {
        Assert.notNull((Object)headers);
        RowContext rowContext = this.doWriteRow(rowNum, map, headers, cellStyleMapper, 0);
        this.currentRowNum = rowContext.getEndRowNum();
        return rowContext;
    }

    public RowContext writeMapRow(Map<String, Object> rowData, Headers headers, CellStyleMapper cellStyleMapper) {
        return this.writeMapRow(this.currentRowNum + 1, rowData, headers, cellStyleMapper);
    }

    public RowContext writeMapRow(Map<String, Object> rowData, Headers headers) {
        return this.writeMapRow(rowData, headers, null);
    }

    public RowContext writeMapRowWithDefaultStyle(int rowNum, Map<String, Object> map, Headers headers) {
        return this.writeMapRow(rowNum, map, headers, cell -> CellStyleSets.DATA_CELL_STYLE);
    }

    public RowContext writeMapRowWithDefaultStyle(Map<String, Object> map, Headers headers) {
        return this.writeMapRowWithDefaultStyle(this.currentRowNum + 1, map, headers);
    }

    protected RowContext doWriteRow(int rowNum, int columnNum, List<?> rowData, CellStyleMapper cellStyleMapper) {
        RowContext rowContext = RowContext.createRow(rowNum, columnNum, rowData, null);
        this.writeRow(rowContext, cellStyleMapper);
        return rowContext;
    }

    protected int doWriteRow(int rowNum, Headers headers, CellStyleMapper cellStyleMapper) {
        List<IMergedCell> cells = headers.createHeaderCells(rowNum);
        int maxEndRowNum = rowNum;
        for (IMergedCell cell : cells) {
            this.writeCell(cell, cellStyleMapper);
            maxEndRowNum = Math.max(cell.getLastRowNum(), maxEndRowNum);
        }
        return maxEndRowNum;
    }

    protected RowContext doWriteRow(int rowNum, Map<String, Object> rowData, Headers headers, CellStyleMapper cellStyleMapper, int itemIndex) {
        RowContext rowContext = this.mapRowWriter.writeRow(rowNum, rowData, headers, itemIndex);
        this.writeRow(rowContext, cellStyleMapper);
        return rowContext;
    }

    protected RowContext doWriteRow(int startRowNum, Object rowData, Headers headers, CellStyleMapper cellStyleMapper, int itemIndex) {
        RowContext rowContext = headers.isIndex() ? this.indexRowWriter.writeRow(startRowNum, rowData, headers, itemIndex) : this.mapRowWriter.writeRow(startRowNum, BeanUtil.toMap((Object)rowData), headers, itemIndex);
        this.writeRow(rowContext, cellStyleMapper);
        this.currentRowNum = startRowNum;
        return rowContext;
    }

    public SheetWriter validData(int startRowNum, int rowCount, Headers headers) {
        Assert.isTrue((rowCount > 0 ? 1 : 0) != 0);
        List<IHeader> headerList = headers.getHeaders();
        if (CollectionUtil.isNotEmpty(headerList)) {
            Map<String, Object> rowMap = Collections.emptyMap();
            for (int i = 0; i < rowCount; ++i) {
                this.doWriteRow(startRowNum + i, rowMap, headers, null, 0);
            }
            this.flush();
        }
        return this;
    }

    public SheetWriter validData(int rowCount, Headers headers) {
        return this.validData(this.currentRowNum + 1, rowCount, headers);
    }
}

