/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jexx.bean.BeanUtil;
import jexx.log.Log;
import jexx.log.LogFactory;
import jexx.poi.RowMapper;
import jexx.poi.cell.ICell;
import jexx.poi.cell.IMergedCell;
import jexx.poi.header.Headers;
import jexx.poi.header.IDataHeader;
import jexx.poi.meta.node.INode;
import jexx.poi.read.SheetCellReader;
import jexx.poi.row.RowActionPredicate;
import jexx.poi.row.RowMap;
import jexx.poi.row.RowScanAction;
import jexx.util.Assert;
import jexx.util.CollectionUtil;
import jexx.util.StringUtil;
import org.apache.poi.ss.usermodel.Sheet;

public class SheetReader
extends SheetCellReader {
    private static final Log LOG = LogFactory.get(SheetReader.class);
    private static final int FIRST_ROW_NUM = 1;
    protected int currentRowNum = 1;
    private boolean skipEmptyRow = false;
    protected boolean supportTrimData = true;

    public SheetReader(Sheet sheet) {
        super(sheet);
    }

    public SheetReader passCurrentRow() {
        this.skipRows(1);
        return this;
    }

    public SheetReader skipRows(int skipRowSize) {
        this.currentRowNum += skipRowSize;
        return this;
    }

    public SheetReader jumpToRowNum(int rowNum) {
        Assert.isTrue((rowNum > 0 ? 1 : 0) != 0, (String)"rowNum is not illegal", (Object[])new Object[0]);
        this.currentRowNum = rowNum;
        return this;
    }

    public SheetReader startSkipEmptyRow() {
        this.skipEmptyRow = true;
        return this;
    }

    public SheetReader setSupportTrimData(boolean supportTrimData) {
        this.supportTrimData = supportTrimData;
        return this;
    }

    public SheetReader reset() {
        this.currentRowNum = 1;
        return this;
    }

    public <T> T readRow(int rowNum, int startColumnNum, int endColumnNum, RowMapper<T> rowMapper) {
        Assert.isTrue((rowNum >= 1 && rowNum <= this.lastRowNumOfSheet ? 1 : 0) != 0, (String)"Sheet[{}]'s last row num is {}", (Object[])new Object[]{this.sheet.getSheetName(), this.lastRowNumOfSheet});
        Assert.isTrue((endColumnNum >= startColumnNum ? 1 : 0) != 0, (String)"endColumnNum[{}] must be equal or greater than startColumnNum[{}]", (Object[])new Object[]{startColumnNum, endColumnNum});
        this.currentRowNum = rowNum;
        int minColumnNum = Math.max(1, startColumnNum);
        int lastCellNum = this.getLastCellNumAtOneRow(rowNum);
        if (lastCellNum == -1) {
            return null;
        }
        int maxColumnNum = Math.min(lastCellNum, endColumnNum);
        List<IMergedCell> cells = this.readCellsAtOneRow(rowNum, minColumnNum, maxColumnNum);
        return rowMapper.mapRow(cells, rowNum);
    }

    public <T> T readRow(int rowNum, RowMapper<T> rowMapper) {
        return this.readRow(rowNum, 1, this.getLastCellNumOfCurrentRow(), rowMapper);
    }

    public <T> T readRow(RowMapper<T> rowMapper) {
        return this.readRow(this.currentRowNum, rowMapper);
    }

    public <T> List<T> readRows(int lastRowNum, RowMapper<T> rowMapper, boolean includeNull) {
        ArrayList<T> list = new ArrayList<T>();
        if (this.currentRowNum > lastRowNum) {
            return list;
        }
        for (int rowNum = this.currentRowNum; rowNum <= lastRowNum; ++rowNum) {
            T t = this.readRow(rowNum, rowMapper);
            if (t == null && !includeNull) continue;
            list.add(t);
        }
        return list;
    }

    public <T> List<T> readRows(RowMapper<T> rowMapper, boolean includeNull) {
        return this.readRows(this.lastRowNumOfSheet, rowMapper, includeNull);
    }

    public <T> List<T> readRows(RowMapper<T> rowMapper) {
        return this.readRows(rowMapper, false);
    }

    public List<Object> readListRow(int readRowNum, int startColumnNum, int endColumnNum) {
        Assert.isTrue((startColumnNum > 0 && endColumnNum >= startColumnNum ? 1 : 0) != 0, (String)"rowNum={},startColumnNum={},endColumnNum={}", (Object[])new Object[]{this.currentRowNum, startColumnNum, endColumnNum});
        return this.readRow(readRowNum, startColumnNum, endColumnNum, (rowData, rowNum) -> rowData.stream().map(ICell::getValue).collect(Collectors.toList()));
    }

    public List<Object> readListRow(int startColumnNum) {
        return this.readListRow(this.currentRowNum, startColumnNum, this.getLastCellNumOfCurrentRow());
    }

    public List<Object> readListRow() {
        return this.readListRow(1);
    }

    public List<List<Object>> readListRows(int readRowNum, int startColumnNum, int endColumnNum) {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        for (int i = readRowNum; i <= this.lastRowNumOfSheet; ++i) {
            List<Object> data = this.readListRow(i, startColumnNum, endColumnNum);
            if (data == null) continue;
            list.add(data);
        }
        return list;
    }

    public List<List<Object>> readListRows(int startColumnNum, int endColumnNum) {
        return this.readListRows(this.currentRowNum, startColumnNum, endColumnNum);
    }

    public List<List<Object>> readListRows(int startColumnNum) {
        int lastCellNum = this.getLastCellNumOfCurrentRow();
        return this.readListRows(startColumnNum, lastCellNum);
    }

    public List<List<Object>> readListRows() {
        return this.readListRows(1);
    }

    public Map<String, Object> readMapRow(int readRowNum, Headers headers) {
        Assert.isTrue((headers != null && CollectionUtil.isNotEmpty(headers.getHeaders()) ? 1 : 0) != 0, (String)"headers not empty", (Object[])new Object[0]);
        int minHeaderNum = 0;
        int maxHeaderNum = 0;
        for (IDataHeader dataHeader : headers.getDataHeaders()) {
            if (minHeaderNum == 0) {
                minHeaderNum = dataHeader.getStartColumnNum();
                maxHeaderNum = dataHeader.getStartColumnNum();
                continue;
            }
            minHeaderNum = Math.min(minHeaderNum, dataHeader.getStartColumnNum());
            maxHeaderNum = Math.max(maxHeaderNum, dataHeader.getStartColumnNum());
        }
        return this.readRow(readRowNum, minHeaderNum, maxHeaderNum, (cells, rowNum) -> {
            RowMap labelMap = new RowMap();
            for (IMergedCell cell : cells) {
                IDataHeader header = headers.getDataHeaderByColumnNum(cell.getFirstColumnNum());
                if (header == null) continue;
                String key = header.getKey();
                Object value = cell.getValue();
                if (this.supportTrimData && value instanceof String) {
                    value = StringUtil.trim((String)value.toString());
                }
                if (header.getUnwrapLabelFunction() != null) {
                    value = header.getUnwrapLabelFunction().unwrap(value);
                }
                labelMap.putIfAbsent(key, value);
            }
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            for (IDataHeader dataHeader : headers.getDataHeaders()) {
                INode node = dataHeader.getNodeByLabel(labelMap);
                if (node == null) continue;
                dataMap.put(dataHeader.getKey(), node.getValue());
            }
            return dataMap;
        });
    }

    public Map<String, Object> readMapRow(Headers headers) {
        return this.readMapRow(this.currentRowNum, headers);
    }

    public List<Map<String, Object>> readMapRows(int rowNum, Headers headers) {
        if (rowNum > this.lastRowNumOfSheet) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        for (int i = rowNum; i <= this.lastRowNumOfSheet; ++i) {
            Map<String, Object> map = this.readMapRow(i, headers);
            if (this.skipEmptyRow && this.checkMapEmpty(map)) continue;
            maps.add(map);
        }
        return maps;
    }

    public List<Map<String, Object>> readMapRows(Headers headers) {
        return this.readMapRows(this.currentRowNum, headers);
    }

    public <T> T readBeanRow(int rowNum, Class<T> clazz, Headers headers) {
        Map<String, Object> map = this.readMapRow(rowNum, headers);
        return (T)BeanUtil.toBean(clazz, map);
    }

    public <T> T readBeanRow(Class<T> clazz, Headers headers) {
        return this.readBeanRow(this.currentRowNum, clazz, headers);
    }

    public <T> List<T> readBeanRows(int readRowNum, Class<T> clazz, Headers headers, RowActionPredicate<T> skipRow) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = readRowNum; i <= this.lastRowNumOfSheet; ++i) {
            Object t;
            Map<String, Object> map = this.readMapRow(i, headers);
            if (this.skipEmptyRow && this.checkMapEmpty(map) || map == null || (t = BeanUtil.toBean(clazz, map)) == null) continue;
            if (skipRow == null) {
                list.add(t);
                continue;
            }
            RowScanAction action = skipRow.action(t, this.currentRowNum);
            if (RowScanAction.STOP == action) break;
            if (RowScanAction.KEEP_AND_STOP == action) {
                list.add(t);
                break;
            }
            list.add(t);
        }
        return list;
    }

    public <T> List<T> readBeanRows(int rowNum, Class<T> clazz, Headers headers) {
        return this.readBeanRows(rowNum, clazz, headers, null);
    }

    public <T> List<T> readBeanRows(Class<T> clazz, Headers headers, RowActionPredicate<T> skipRow) {
        return this.readBeanRows(this.currentRowNum, clazz, headers, skipRow);
    }

    public <T> List<T> readBeanRows(Class<T> clazz, Headers headers) {
        return this.readBeanRows(clazz, headers, null);
    }

    public boolean validateHeaders(int validateRowNum, Headers headers) {
        if (CollectionUtil.isEmpty(headers.getDataHeaders())) {
            return false;
        }
        List<IMergedCell> cells = this.readCellsAtOneRow(validateRowNum);
        if (CollectionUtil.isEmpty(cells)) {
            return false;
        }
        Map<Integer, Object> map = cells.stream().filter(s -> s.getValue() != null).collect(Collectors.toMap(ICell::getFirstColumnNum, ICell::getValue));
        for (IDataHeader header : headers.getDataHeaders()) {
            String mapValue = (String)map.get(header.getStartColumnNum());
            if (header.getValue().equals(mapValue)) continue;
            LOG.warn("validate header[{}] failed, now is \"{}\"!", new Object[]{header.getValue(), mapValue});
            return false;
        }
        return true;
    }

    public boolean validateHeaders(Headers headers) {
        return this.validateHeaders(this.currentRowNum, headers);
    }

    protected int getLastCellNumOfCurrentRow() {
        return this.getLastCellNumAtOneRow(this.currentRowNum);
    }

    private boolean checkMapEmpty(Map<String, Object> map) {
        if (map == null) {
            return true;
        }
        for (Map.Entry<String, Object> m : map.entrySet()) {
            Object value = m.getValue();
            if (value == null || value instanceof String && StringUtil.isEmpty((CharSequence)((String)value))) continue;
            return false;
        }
        return true;
    }
}

